/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus.enricher;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import java.util.Properties;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.specific.AbstractHealthCheckEnricher;
import org.eclipse.jkube.quarkus.QuarkusUtils;

public class QuarkusHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    private final Properties quarkusApplicationConfiguration = QuarkusUtils.getQuarkusConfiguration(this.getContext().getProject());

    public QuarkusHealthCheckEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-healthcheck-quarkus");
        this.log.debug("Quarkus Application Config loaded from: %s", new Object[]{this.quarkusApplicationConfiguration.get("jkube.internal.application-config-file.path")});
    }

    protected Probe getReadinessProbe() {
        return this.discoverQuarkusHealthCheck(Configs.asInteger((String)this.getConfig(Config.READINESS_INITIAL_DELAY, "5")), QuarkusUtils::resolveQuarkusReadinessPath);
    }

    protected Probe getLivenessProbe() {
        return this.discoverQuarkusHealthCheck(Configs.asInteger((String)this.getConfig(Config.LIVENESS_INITIAL_DELAY, "10")), QuarkusUtils::resolveQuarkusLivenessPath);
    }

    protected Probe getStartupProbe() {
        if (QuarkusUtils.isStartupEndpointSupported(this.getContext().getProject())) {
            return this.discoverQuarkusHealthCheck(Configs.asInteger((String)this.getConfig(Config.STARTUP_INITIAL_DELAY, "5")), QuarkusUtils::resolveQuarkusStartupPath);
        }
        return null;
    }

    private Probe discoverQuarkusHealthCheck(int initialDelay, Function<JavaProject, String> pathResolver) {
        if (!this.getContext().hasDependency("io.quarkus", "quarkus-smallrye-health")) {
            return null;
        }
        return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort((Object)Configs.asInteger((String)QuarkusUtils.extractPort(this.getContext().getProject(), this.quarkusApplicationConfiguration, this.getConfig(Config.PORT))))).withPath(this.resolveHealthPath(pathResolver.apply(this.getContext().getProject())))).withScheme(this.getConfig(Config.SCHEME))).endHttpGet()).withFailureThreshold(Configs.asInteger((String)this.getConfig(Config.FAILURE_THRESHOLD)))).withSuccessThreshold(Configs.asInteger((String)this.getConfig(Config.SUCCESS_THRESHOLD)))).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
    }

    private String resolveHealthPath(String subPath) {
        if (StringUtils.isNotBlank((CharSequence)this.getConfig(Config.HEALTH_PATH))) {
            return QuarkusUtils.concatPath(this.getConfig(Config.HEALTH_PATH), subPath);
        }
        return QuarkusUtils.resolveCompleteQuarkusHealthRootPath(this.getContext().getProject(), subPath);
    }

    private static enum Config implements Configs.Config
    {
        SCHEME("scheme", "HTTP"),
        PORT("port", "8080"),
        FAILURE_THRESHOLD("failureThreshold", "3"),
        SUCCESS_THRESHOLD("successThreshold", "1"),
        LIVENESS_INITIAL_DELAY("livenessInitialDelay", null),
        READINESS_INITIAL_DELAY("readinessInitialDelay", null),
        STARTUP_INITIAL_DELAY("startupInitialDelay", null),
        HEALTH_PATH("path", null);

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

