/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;
import org.eclipse.jkube.kit.common.util.YamlUtil;

public class QuarkusUtils {
    private static final String QUARKUS_HTTP_PORT = "quarkus.http.port";
    private static final String QUARKUS_PACKAGE_RUNNER_SUFFIX = "quarkus.package.runner-suffix";

    private QuarkusUtils() {
    }

    public static String extractPort(JavaProject javaProject, Properties properties, String defaultValue) {
        String profilePort;
        Optional<String> activeProfile = QuarkusUtils.getActiveProfile(javaProject);
        if (activeProfile.isPresent() && StringUtils.isNotBlank((CharSequence)(profilePort = properties.getProperty(String.format("%%%s.%s", activeProfile.get(), QUARKUS_HTTP_PORT))))) {
            return profilePort;
        }
        return properties.getProperty(QUARKUS_HTTP_PORT, defaultValue);
    }

    public static String runnerSuffix(Properties properties) {
        return properties.getProperty(QUARKUS_PACKAGE_RUNNER_SUFFIX, "-runner");
    }

    public static String findSingleFileThatEndsWith(JavaProject project, String suffix) {
        File buildDir = project.getBuildDirectory();
        String[] file = buildDir.list((dir, name) -> name.endsWith(suffix));
        if (file == null || file.length != 1) {
            throw new IllegalStateException("Can't find single file with suffix '" + suffix + "' in " + buildDir + " (zero or more than one files found ending with '" + suffix + "')");
        }
        return file[0];
    }

    public static Properties getQuarkusConfiguration(JavaProject project) {
        Supplier[] sources;
        URLClassLoader urlClassLoader = JKubeProjectUtil.getClassLoader((JavaProject)project);
        for (Supplier source : sources = new Supplier[]{() -> PropertiesUtil.getPropertiesFromResource((URL)urlClassLoader.findResource("application.properties")), () -> YamlUtil.getPropertiesFromYamlResource((URL)urlClassLoader.findResource("application.yaml")), () -> YamlUtil.getPropertiesFromYamlResource((URL)urlClassLoader.findResource("application.yml"))}) {
            Properties props = (Properties)source.get();
            if (props.isEmpty()) continue;
            props.putAll((Map<?, ?>)PropertiesUtil.toMap((Properties)project.getProperties()));
            return props;
        }
        return project.getProperties();
    }

    private static Optional<String> getActiveProfile(JavaProject project) {
        return Optional.ofNullable(project).map(JavaProject::getProperties).map(properties -> properties.get("quarkus.profile")).map(Object::toString);
    }
}

