/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.quarkus.QuarkusUtils;
import org.eclipse.jkube.quarkus.generator.QuarkusGenerator;

public class QuarkusAssemblies {
    public static final QuarkusAssembly NATIVE = quarkusGenerator -> {
        JavaProject project = quarkusGenerator.getContext().getProject();
        Properties quarkusConfiguration = QuarkusUtils.getQuarkusConfiguration(project);
        ArrayList<String> relativePaths = new ArrayList<String>();
        relativePaths.add(QuarkusUtils.findSingleFileThatEndsWith(project, QuarkusUtils.runnerSuffix(quarkusConfiguration)));
        AssemblyFileSet fileSet = AssemblyFileSet.builder().directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)project.getBuildDirectory())).includes(relativePaths).fileMode("0755").build();
        return QuarkusAssemblies.createAssemblyConfiguration(quarkusGenerator.getBuildWorkdir(), fileSet);
    };
    public static final QuarkusAssembly FAST_JAR = quarkusGenerator -> {
        JavaProject project = quarkusGenerator.getContext().getProject();
        File quarkusAppDirectory = new File(project.getBuildDirectory(), "quarkus-app");
        if (!quarkusAppDirectory.exists()) {
            throw new IllegalStateException("The quarkus-app directory required in Quarkus Fast Jar mode was not found");
        }
        AssemblyFileSet.AssemblyFileSetBuilder fileSetBuilder = AssemblyFileSet.builder().directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)quarkusAppDirectory)).include("quarkus-run.jar").include("*").include("**/*").fileMode("0640");
        QuarkusAssemblies.addDefaultArtifactExclude(project, fileSetBuilder);
        return QuarkusAssemblies.createAssemblyConfiguration(quarkusGenerator.getBuildWorkdir(), fileSetBuilder.build());
    };
    public static final QuarkusAssembly LEGACY_JAR = quarkusGenerator -> {
        JavaProject project = quarkusGenerator.getContext().getProject();
        AssemblyFileSet.AssemblyFileSetBuilder fileSetBuilder = AssemblyFileSet.builder().directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)project.getBuildDirectory())).include(QuarkusUtils.findSingleFileThatEndsWith(project, QuarkusUtils.runnerSuffix(QuarkusUtils.getQuarkusConfiguration(project)) + ".jar")).include("lib").fileMode("0640");
        QuarkusAssemblies.addDefaultArtifactExclude(project, fileSetBuilder);
        return QuarkusAssemblies.createAssemblyConfiguration(quarkusGenerator.getBuildWorkdir(), fileSetBuilder.build());
    };
    public static final QuarkusAssembly UBER_JAR = quarkusGenerator -> {
        JavaProject project = quarkusGenerator.getContext().getProject();
        AssemblyFileSet.AssemblyFileSetBuilder fileSetBuilder = AssemblyFileSet.builder().directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)project.getBuildDirectory())).include(QuarkusUtils.findSingleFileThatEndsWith(project, QuarkusUtils.runnerSuffix(QuarkusUtils.getQuarkusConfiguration(project)) + ".jar")).fileMode("0640");
        QuarkusAssemblies.addDefaultArtifactExclude(project, fileSetBuilder);
        return QuarkusAssemblies.createAssemblyConfiguration(quarkusGenerator.getBuildWorkdir(), fileSetBuilder.build());
    };

    private static void addDefaultArtifactExclude(JavaProject project, AssemblyFileSet.AssemblyFileSetBuilder fileSetBuilder) {
        File defaultJarFile = JKubeProjectUtil.getFinalOutputArtifact((JavaProject)project);
        if (defaultJarFile != null) {
            fileSetBuilder.exclude(defaultJarFile.getName());
        }
    }

    private static AssemblyConfiguration createAssemblyConfiguration(String targetDir, AssemblyFileSet jKubeAssemblyFileSet) {
        jKubeAssemblyFileSet.setOutputDirectory(".");
        return AssemblyConfiguration.builder().targetDir(targetDir).excludeFinalOutputArtifact(true).inline(Assembly.builder().fileSet(jKubeAssemblyFileSet).build()).build();
    }

    @FunctionalInterface
    public static interface QuarkusAssembly {
        public AssemblyConfiguration createAssemblyConfiguration(QuarkusGenerator var1);
    }
}

