/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.javaexec.JavaExecGenerator;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.Arguments;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.quarkus.QuarkusMode;
import org.eclipse.jkube.quarkus.QuarkusUtils;

public class QuarkusGenerator
extends JavaExecGenerator {
    public static final String QUARKUS = "quarkus";

    public QuarkusGenerator(GeneratorContext context) {
        super(context, QUARKUS);
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && QuarkusUtils.hasQuarkusPlugin(this.getProject());
    }

    protected String getDefaultWebPort() {
        return QuarkusUtils.extractPort(this.getProject(), QuarkusUtils.getQuarkusConfiguration(this.getProject()), super.getDefaultWebPort());
    }

    protected String getDefaultJolokiaPort() {
        if (this.isNativeImage()) {
            return "0";
        }
        return super.getDefaultJolokiaPort();
    }

    protected String getDefaultPrometheusPort() {
        if (this.isNativeImage()) {
            return "0";
        }
        return super.getDefaultPrometheusPort();
    }

    protected String getFromAsConfigured() {
        if (this.isNativeImage()) {
            return Optional.ofNullable(super.getFromAsConfigured()).orElse(this.getNativeFrom());
        }
        return super.getFromAsConfigured();
    }

    protected AssemblyConfiguration createAssembly() {
        if (this.isNativeImage()) {
            return QuarkusMode.NATIVE.getAssembly().createAssemblyConfiguration(this);
        }
        return QuarkusMode.from(this.getProject()).getAssembly().createAssemblyConfiguration(this);
    }

    protected String getBuildWorkdir() {
        if (this.isNativeImage()) {
            return "/";
        }
        return this.getConfig((Configs.Config)JavaExecGenerator.Config.TARGET_DIR);
    }

    protected Arguments getBuildEntryPoint() {
        if (this.isNativeImage()) {
            Arguments.ArgumentsBuilder ab = Arguments.builder();
            ab.execArgument("./" + QuarkusUtils.findSingleFileThatEndsWith(this.getProject(), QuarkusUtils.runnerSuffix(QuarkusUtils.getQuarkusConfiguration(this.getProject()))));
            this.getExtraJavaOptions().forEach(arg_0 -> ((Arguments.ArgumentsBuilder)ab).execArgument(arg_0));
            return ab.build();
        }
        return null;
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("JAVA_OPTIONS", StringUtils.join(QuarkusGenerator.getJavaOptions(), (String)" "));
        return env;
    }

    private static List<String> getJavaOptions() {
        return Collections.singletonList("-Dquarkus.http.host=0.0.0.0");
    }

    private boolean isNativeImage() {
        return Boolean.parseBoolean(this.getConfig(Config.NATIVE_IMAGE)) || QuarkusMode.from(this.getProject()) == QuarkusMode.NATIVE;
    }

    private String getNativeFrom() {
        if (this.getContext().getRuntimeMode() != RuntimeMode.OPENSHIFT) {
            return "registry.access.redhat.com/ubi8/ubi-minimal:8.1";
        }
        return "quay.io/quarkus/ubi-quarkus-native-binary-s2i:1.0";
    }

    protected boolean isFatJar() {
        return QuarkusMode.from(this.getProject()).isFatJar();
    }

    public static enum Config implements Configs.Config
    {
        NATIVE_IMAGE("nativeImage", "false");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

