/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus;

import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.quarkus.QuarkusUtils;
import org.eclipse.jkube.quarkus.generator.QuarkusAssemblies;

public enum QuarkusMode {
    NATIVE("native", false, QuarkusAssemblies.NATIVE),
    FAST_JAR("fast-jar", false, QuarkusAssemblies.FAST_JAR),
    LEGACY_JAR("legacy-jar", false, QuarkusAssemblies.LEGACY_JAR),
    UBER_JAR("uber-jar", true, QuarkusAssemblies.UBER_JAR);

    private final String packageType;
    private final boolean isFatJar;
    private final QuarkusAssemblies.QuarkusAssembly assembly;

    private QuarkusMode(String packageType, boolean isFatJar, QuarkusAssemblies.QuarkusAssembly assembly) {
        this.packageType = packageType;
        this.isFatJar = isFatJar;
        this.assembly = assembly;
    }

    public boolean isFatJar() {
        return this.isFatJar;
    }

    public QuarkusAssemblies.QuarkusAssembly getAssembly() {
        return this.assembly;
    }

    public static QuarkusMode from(JavaProject project) {
        Properties quarkusConfiguration = QuarkusUtils.getQuarkusConfiguration(project);
        return QuarkusMode.from(quarkusConfiguration).orElseGet(() -> QuarkusMode.fromFiles(project, quarkusConfiguration));
    }

    private static Optional<QuarkusMode> from(Properties properties) {
        return Optional.ofNullable(properties.getProperty("quarkus.package.type")).flatMap(packageType -> Arrays.stream(QuarkusMode.values()).filter(qm -> qm.packageType.equalsIgnoreCase((String)packageType)).findFirst());
    }

    private static QuarkusMode fromFiles(JavaProject project, Properties properties) {
        String runnerSuffix = QuarkusUtils.runnerSuffix(properties);
        if (QuarkusMode.hasFileThatEndsWith(project, runnerSuffix + ".jar") && new File(project.getBuildDirectory(), "lib").exists()) {
            return LEGACY_JAR;
        }
        if (QuarkusMode.hasFileThatEndsWith(project, runnerSuffix + ".jar")) {
            return UBER_JAR;
        }
        if (QuarkusMode.hasFileThatEndsWith(project, runnerSuffix)) {
            return NATIVE;
        }
        return FAST_JAR;
    }

    private static boolean hasFileThatEndsWith(JavaProject project, String suffix) {
        File buildDir = project.getBuildDirectory();
        String[] file = buildDir.list((dir, name) -> name.endsWith(suffix));
        return file != null && file.length > 0;
    }
}

