/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.remotedev;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.Collections;
import java.util.List;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.remotedev.LocalService;
import org.eclipse.jkube.kit.remotedev.RemoteDevelopmentContext;

class LocalServiceManager {
    private static final String PREVIOUS_SERVICE_ANNOTATION = "jkube/previous-service";
    private final KitLogger logger;
    private final KubernetesClient kubernetesClient;
    private final List<LocalService> localServices;

    public LocalServiceManager(RemoteDevelopmentContext context) {
        this.logger = context.getLogger();
        this.kubernetesClient = context.getKubernetesClient();
        this.localServices = context.getRemoteDevelopmentConfig().getLocalServices();
    }

    public void createOrReplaceServices() {
        this.logger.debug("Creating or replacing Kubernetes services for exposed ports from local environment", new Object[0]);
        for (LocalService localService : this.localServices) {
            Service newService;
            Service existingService = (Service)((ServiceResource)this.kubernetesClient.services().withName(localService.getServiceName())).get();
            if (existingService == null) {
                newService = localService.toKubernetesService();
            } else {
                String previousServiceAnnotation;
                if (existingService.getMetadata().getAnnotations().get(PREVIOUS_SERVICE_ANNOTATION) != null) {
                    previousServiceAnnotation = (String)existingService.getMetadata().getAnnotations().get(PREVIOUS_SERVICE_ANNOTATION);
                } else {
                    Service cleanExistingService = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)new ServiceBuilder(existingService).withStatus(null)).editSpec().withClusterIP(null)).withClusterIPs(Collections.emptyList())).withExternalIPs(Collections.emptyList())).endSpec()).build();
                    previousServiceAnnotation = Serialization.asJson((Object)cleanExistingService);
                }
                newService = ((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder(localService.toKubernetesService()).editOrNewMetadata().addToAnnotations(PREVIOUS_SERVICE_ANNOTATION, previousServiceAnnotation)).endMetadata()).build();
            }
            ((ServiceResource)this.kubernetesClient.services().resource((Object)newService)).createOrReplace();
        }
    }

    public void tearDownServices() {
        this.logger.debug("Tearing down Kubernetes services for exposed ports from local environment", new Object[0]);
        for (LocalService localService : this.localServices) {
            Service service = (Service)((ServiceResource)this.kubernetesClient.services().withName(localService.getServiceName())).get();
            if (service != null && service.getMetadata().getAnnotations().get(PREVIOUS_SERVICE_ANNOTATION) != null) {
                Service previousService = (Service)Serialization.unmarshal((String)((String)service.getMetadata().getAnnotations().get(PREVIOUS_SERVICE_ANNOTATION)), Service.class);
                ((ServiceResource)this.kubernetesClient.services().resource((Object)previousService)).createOrReplace();
                continue;
            }
            if (service == null) continue;
            ((ServiceResource)this.kubernetesClient.services().withName(localService.getServiceName())).delete();
        }
    }
}

