/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.remotedev;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.Collections;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.remotedev.LocalService;
import org.eclipse.jkube.kit.remotedev.RemoteDevelopmentContext;

class LocalServiceManager {
    private static final String PREVIOUS_SERVICE_ANNOTATION = "jkube/previous-service";
    private final KitLogger logger;
    private final KubernetesClient kubernetesClient;
    private final RemoteDevelopmentContext context;

    public LocalServiceManager(RemoteDevelopmentContext context) {
        this.context = context;
        this.logger = context.getLogger();
        this.kubernetesClient = context.getKubernetesClient();
    }

    public void createOrReplaceServices() {
        this.logger.debug("Creating or replacing Kubernetes services for exposed ports from local environment", new Object[0]);
        for (LocalService localService : this.context.getRemoteDevelopmentConfig().getLocalServices()) {
            Service newService;
            Service existingService = (Service)((ServiceResource)this.kubernetesClient.services().withName(localService.getServiceName())).get();
            if (existingService == null) {
                newService = localService.toKubernetesService();
            } else {
                String previousServiceAnnotation;
                if (existingService.getMetadata().getAnnotations().get(PREVIOUS_SERVICE_ANNOTATION) != null) {
                    previousServiceAnnotation = (String)existingService.getMetadata().getAnnotations().get(PREVIOUS_SERVICE_ANNOTATION);
                } else {
                    Service sanitizedExistingService = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)new ServiceBuilder(existingService).withStatus(null)).editSpec().withClusterIP(null)).withClusterIPs(Collections.emptyList())).withExternalIPs(Collections.emptyList())).endSpec()).build();
                    previousServiceAnnotation = Serialization.asJson((Object)sanitizedExistingService);
                }
                ServiceBuilder newServiceBuilder = (ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder(localService.toKubernetesService()).editOrNewMetadata().addToAnnotations(PREVIOUS_SERVICE_ANNOTATION, previousServiceAnnotation)).endMetadata();
                if (existingService.getSpec().getPorts() != null && existingService.getSpec().getPorts().size() == 1) {
                    ((ServiceFluent.SpecNested)newServiceBuilder.editOrNewSpec().withPorts(existingService.getSpec().getPorts())).endSpec();
                }
                newService = newServiceBuilder.build();
            }
            ((ServiceResource)this.kubernetesClient.services().resource((Object)newService)).createOrReplace();
            this.context.getManagedServices().put(localService, newService);
        }
    }

    public void tearDownServices() {
        this.logger.debug("Tearing down Kubernetes services for exposed ports from local environment", new Object[0]);
        for (Service managedService : this.context.getManagedServices().values()) {
            Service service = (Service)((ServiceResource)this.kubernetesClient.services().resource((Object)managedService)).fromServer().get();
            if (service != null && service.getMetadata().getAnnotations().get(PREVIOUS_SERVICE_ANNOTATION) != null) {
                Service previousService = (Service)Serialization.unmarshal((String)((String)service.getMetadata().getAnnotations().get(PREVIOUS_SERVICE_ANNOTATION)), Service.class);
                ((ServiceResource)this.kubernetesClient.services().resource((Object)previousService)).createOrReplace();
                continue;
            }
            if (service == null) continue;
            ((ServiceResource)this.kubernetesClient.services().resource((Object)service)).delete();
        }
    }
}

