/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.remotedev;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.net.ServerSocket;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.AsyncUtil;
import org.eclipse.jkube.kit.remotedev.KubernetesSshServiceForwarder;
import org.eclipse.jkube.kit.remotedev.LocalServiceManager;
import org.eclipse.jkube.kit.remotedev.PortForwarder;
import org.eclipse.jkube.kit.remotedev.RemoteDevelopmentConfig;
import org.eclipse.jkube.kit.remotedev.RemoteDevelopmentContext;
import org.eclipse.jkube.kit.remotedev.RemoteService;

public class RemoteDevelopmentService {
    static final String REMOTE_DEVELOPMENT_APP = "jkube-remote-dev";
    static final String REMOTE_DEVELOPMENT_GROUP = "jkube-kit";
    private final RemoteDevelopmentContext context;
    private final KitLogger logger;
    private final KubernetesClient kubernetesClient;
    private final KubernetesSshServiceForwarder kubernetesSshServiceForwarder;
    private final PortForwarder portForwarder;
    private final LocalServiceManager localServiceManager;

    public RemoteDevelopmentService(KitLogger logger, KubernetesClient kubernetesClient, RemoteDevelopmentConfig remoteDevelopmentConfig) {
        this.context = new RemoteDevelopmentContext(logger, kubernetesClient, remoteDevelopmentConfig);
        this.logger = logger;
        this.kubernetesClient = kubernetesClient;
        this.kubernetesSshServiceForwarder = new KubernetesSshServiceForwarder(this.context);
        this.portForwarder = new PortForwarder(this.context);
        this.localServiceManager = new LocalServiceManager(this.context);
    }

    public CompletableFuture<Void> start() {
        this.checkEnvironment();
        this.localServiceManager.createOrReplaceServices();
        return CompletableFuture.anyOf(AsyncUtil.async((Callable)this.kubernetesSshServiceForwarder), AsyncUtil.async((Callable)this.portForwarder)).thenApply(object -> null);
    }

    public void stop() {
        this.logger.info("Stopping remote development service...", new Object[0]);
        this.localServiceManager.tearDownServices();
        this.portForwarder.stop();
        this.kubernetesSshServiceForwarder.stop();
        this.logger.info("Remote development service stopped", new Object[0]);
    }

    private void checkEnvironment() {
        for (RemoteService remoteService : this.context.getRemoteDevelopmentConfig().getRemoteServices()) {
            try (ServerSocket ignore = new ServerSocket(remoteService.getLocalPort());){
                this.logger.debug("Local port '%s' for remote service '%s:%s' is available", new Object[]{remoteService.getLocalPort(), remoteService.getHostname(), remoteService.getPort()});
            }
            catch (Exception e) {
                throw new IllegalStateException("Local port '" + remoteService.getLocalPort() + "' is already in use (" + remoteService.getHostname() + ")");
            }
            if (((ServiceResource)this.kubernetesClient.services().withName(remoteService.getHostname())).get() != null) continue;
            this.logger.warn("Service '%s' does not exist in the cluster, you won't be able to access it until it is created", new Object[]{remoteService.getHostname()});
        }
    }
}

