/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.remotedev;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.AsyncUtil;
import org.eclipse.jkube.kit.remotedev.LocalService;
import org.eclipse.jkube.kit.remotedev.RemoteDevelopmentContext;

class KubernetesSshServiceForwarder
implements Callable<Void> {
    private final KitLogger logger;
    private final KubernetesClient kubernetesClient;
    private final RemoteDevelopmentContext context;
    private final AtomicBoolean stop;
    private Pod sshService;

    KubernetesSshServiceForwarder(RemoteDevelopmentContext context) {
        this.logger = context.getLogger();
        this.kubernetesClient = context.getKubernetesClient();
        this.context = context;
        this.stop = new AtomicBoolean(false);
    }

    @Override
    public Void call() throws IOException, InterruptedException {
        this.logger.debug("Starting Kubernetes SSH service forwarder...", new Object[0]);
        InetAddress allInterfaces = InetAddress.getByName("0.0.0.0");
        while (!this.stop.get()) {
            if (this.sshService == null || ((PodResource)this.kubernetesClient.pods().resource((Object)this.sshService)).get() == null) {
                this.context.reset();
                this.sshService = this.deploySshServerPod();
            }
            this.logger.info("Waiting for JKube remote development Pod [%s] to be ready...", new Object[]{this.sshService.getMetadata().getName()});
            ((PodResource)this.kubernetesClient.pods().resource((Object)this.sshService)).waitUntilReady(10L, TimeUnit.SECONDS);
            this.logger.info("JKube remote development Pod [%s] is ready", new Object[]{this.sshService.getMetadata().getName()});
            this.context.setUser(this.waitForUser());
            this.logger.info("Opening remote development connection to Kubernetes: %s:%s%n", new Object[]{this.sshService.getMetadata().getName(), this.context.getSshPort()});
            LocalPortForward localPortForward = ((PodResource)this.kubernetesClient.pods().resource((Object)this.sshService)).portForward(this.context.getRemoteDevPodPort(), allInterfaces, this.context.getSshPort());
            Throwable throwable = null;
            try {
                while (!this.shouldRestart(this.sshService, localPortForward)) {
                    TimeUnit.SECONDS.sleep(1L);
                    if (!this.stop.get()) continue;
                    Void void_ = null;
                    return void_;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (localPortForward == null) continue;
                if (throwable != null) {
                    try {
                        localPortForward.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                localPortForward.close();
            }
        }
        return null;
    }

    final void stop() {
        if (this.sshService != null) {
            this.logger.info("Removing JKube remote development Pod [%s]...", new Object[]{this.sshService.getMetadata().getName()});
            ((PodResource)this.kubernetesClient.pods().withName(this.sshService.getMetadata().getName())).delete();
        }
        this.stop.set(true);
    }

    private Pod deploySshServerPod() {
        String name = "jkube-remote-dev-" + this.context.getSessionID();
        PodBuilder pod = (PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(name)).addToLabels("app.kubernetes.io/instance", this.context.getSessionID().toString())).addToLabels("app.kubernetes.io/name", "jkube-remote-dev")).addToLabels("app.kubernetes.io/part-of", "jkube-kit")).endMetadata()).withNewSpec().addNewContainer().withName("jkube-remote-dev")).addToEnv(new EnvVar[]{((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("PUBLIC_KEY")).withValue(this.context.getSshRsaPublicKey())).build()})).withImage(this.context.getRemoteDevPodImage())).addNewPort().withContainerPort(Integer.valueOf(this.context.getRemoteDevPodPort()))).withProtocol("TCP")).endPort()).endContainer()).endSpec();
        for (LocalService localService : this.context.getRemoteDevelopmentConfig().getLocalServices()) {
            ((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)pod.editSpec().editFirstContainer().addNewPort().withContainerPort(Integer.valueOf(localService.getPort()))).withProtocol("TCP")).endPort()).endContainer()).endSpec();
        }
        return (Pod)((PodResource)this.kubernetesClient.pods().resource((Object)pod.build())).createOrReplace();
    }

    private String waitForUser() throws InterruptedException {
        this.logger.debug("Waiting for Pod to log current user", new Object[0]);
        try {
            String log = (String)((CompletableFuture)AsyncUtil.await(() -> ((PodResource)this.kubernetesClient.pods().resource((Object)this.sshService)).getLog()).apply(l -> l.contains("Current container user is:"))).get(60L, TimeUnit.SECONDS);
            int i = log.indexOf("Current container user is:");
            return log.substring(i + 26, log.indexOf("\n") + i).trim();
        }
        catch (ExecutionException | TimeoutException ex) {
            throw new IllegalStateException("Unable to retrieve current user from Pod", ex);
        }
    }

    private boolean shouldRestart(Pod sshService, LocalPortForward localPortForward) {
        if (((PodResource)this.kubernetesClient.pods().resource((Object)sshService)).get() == null) {
            this.logger.warn("JKube remote development Pod is gone, recreating", new Object[0]);
            return true;
        }
        if (localPortForward.errorOccurred()) {
            this.logger.warn("Kubernetes tunneling service error, restarting", new Object[0]);
            return true;
        }
        if (!localPortForward.isAlive()) {
            this.logger.warn("Kubernetes tunneling service dead, restarting", new Object[0]);
            return true;
        }
        return false;
    }
}

