/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm;

import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.resource.helm.GeneratedChartListener;
import org.eclipse.jkube.kit.resource.helm.Maintainer;

public class HelmConfig {
    private String chart;
    private String chartExtension;
    private String version;
    private String description;
    private String home;
    private List<String> sources;
    private List<Maintainer> maintainers;
    private String icon;
    private List<String> keywords;
    private String engine;
    private List<File> additionalFiles;
    private List<Template> templates;
    private List<HelmType> types;
    private String sourceDir;
    private String outputDir;
    private String tarballOutputDir;
    private List<GeneratedChartListener> generatedChartListeners;

    public String getChart() {
        return this.chart;
    }

    public void setChart(String chart) {
        this.chart = chart;
    }

    public String getChartExtension() {
        return this.chartExtension;
    }

    public void setChartExtension(String chartExtension) {
        this.chartExtension = chartExtension;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public List<Maintainer> getMaintainers() {
        return this.maintainers;
    }

    public void setMaintainers(List<Maintainer> maintainers) {
        this.maintainers = maintainers;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public List<File> getAdditionalFiles() {
        return this.additionalFiles;
    }

    public void setAdditionalFiles(List<File> additionalFiles) {
        this.additionalFiles = additionalFiles;
    }

    public List<Template> getTemplates() {
        return this.templates;
    }

    public void setTemplates(List<Template> templates) {
        this.templates = templates;
    }

    public List<HelmType> getTypes() {
        return this.types;
    }

    public void setTypes(List<HelmType> types) {
        this.types = types;
    }

    public void setType(String types) {
        this.setTypes(HelmType.parseString(types));
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public String getTarballOutputDir() {
        return this.tarballOutputDir;
    }

    public void setTarballOutputDir(String tarballOutputDir) {
        this.tarballOutputDir = tarballOutputDir;
    }

    public List<GeneratedChartListener> getGeneratedChartListeners() {
        return this.generatedChartListeners;
    }

    public void setGeneratedChartListeners(List<GeneratedChartListener> generatedChartListeners) {
        this.generatedChartListeners = generatedChartListeners;
    }

    public static enum HelmType {
        KUBERNETES("helm", "kubernetes", "kubernetes", "Kubernetes"),
        OPENSHIFT("helmshift", "openshift", "openshift", "OpenShift");

        private final String classifier;
        private final String sourceDir;
        private final String outputDir;
        private final String description;

        private HelmType(String classifier, String sourceDir, String outputDir, String description) {
            this.classifier = classifier;
            this.sourceDir = sourceDir;
            this.outputDir = outputDir;
            this.description = description;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getSourceDir() {
            return this.sourceDir;
        }

        public String getOutputDir() {
            return this.outputDir;
        }

        public String getDescription() {
            return this.description;
        }

        public static List<HelmType> parseString(String types) {
            return Optional.ofNullable(types).map(t -> t.split(",")).map(Stream::of).map(s -> s.filter(StringUtils::isNotBlank).map(String::toUpperCase).map(HelmType::valueOf).collect(Collectors.toList())).orElse(Collections.emptyList());
        }
    }
}

