/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.archive.ArchiveCompression;
import org.eclipse.jkube.kit.common.archive.JKubeTarArchiver;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.common.util.TemplateUtil;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.resource.helm.Chart;
import org.eclipse.jkube.kit.resource.helm.HelmConfig;
import org.eclipse.jkube.kit.resource.helm.HelmParameter;

public class HelmService {
    private static final String YAML_EXTENSION = ".yaml";
    private static final String CHART_FILENAME = "Chart.yaml";
    private static final String VALUES_FILENAME = "values.yaml";

    private HelmService() {
    }

    public static void generateHelmCharts(KitLogger logger, HelmConfig helmConfig) throws IOException {
        for (HelmConfig.HelmType helmType : helmConfig.getTypes()) {
            logger.info("Creating Helm Chart \"%s\" for %s", new Object[]{helmConfig.getChart(), helmType.getDescription()});
            logger.debug("Source directory: %s", new Object[]{helmConfig.getSourceDir()});
            logger.debug("OutputDir: %s", new Object[]{helmConfig.getOutputDir()});
            File sourceDir = HelmService.prepareSourceDir(helmConfig, helmType);
            File outputDir = HelmService.prepareOutputDir(helmConfig, helmType);
            File tarballOutputDir = new File(Objects.requireNonNull(helmConfig.getTarballOutputDir(), "Tarball output directory is required"));
            File templatesDir = new File(outputDir, "templates");
            FileUtils.forceMkdir((File)templatesDir);
            logger.debug("Processing source files", new Object[0]);
            HelmService.processSourceFiles(sourceDir, templatesDir);
            logger.debug("Creating %s", new Object[]{CHART_FILENAME});
            HelmService.createChartYaml(helmConfig, outputDir);
            logger.debug("Copying additional files", new Object[0]);
            HelmService.copyAdditionalFiles(helmConfig, outputDir);
            logger.debug("Processing YAML templates", new Object[0]);
            HelmService.createTemplateParameters(helmConfig, outputDir, templatesDir);
            File tarballFile = new File(tarballOutputDir, String.format("%s-%s-%s.%s", helmConfig.getChart(), helmConfig.getVersion(), helmType.getClassifier(), helmConfig.getChartExtension()));
            logger.debug("Creating Helm configuration Tarball: '%s'", new Object[]{tarballFile.getAbsolutePath()});
            JKubeTarArchiver.createTarBallOfDirectory((File)tarballFile, (File)outputDir, (ArchiveCompression)ArchiveCompression.fromFileName((String)tarballFile.getName()));
            Optional.ofNullable(helmConfig.getGeneratedChartListeners()).orElse(Collections.emptyList()).forEach(listener -> listener.chartFileGenerated(helmConfig, helmType, tarballFile));
        }
    }

    static File prepareSourceDir(HelmConfig helmConfig, HelmConfig.HelmType type) throws IOException {
        File sourceDir = new File(helmConfig.getSourceDir(), type.getSourceDir());
        if (!sourceDir.isDirectory()) {
            throw new IOException(String.format("Chart source directory %s does not exist so cannot make chart \"%s\". Probably you need run 'mvn kubernetes:resource' before.", sourceDir.getAbsolutePath(), helmConfig.getChart()));
        }
        if (!HelmService.containsYamlFiles(sourceDir)) {
            throw new IOException(String.format("Chart source directory %s does not contain any YAML manifest to make chart \"%s\". Probably you need run 'mvn kubernetes:resource' before.", sourceDir.getAbsolutePath(), helmConfig.getChart()));
        }
        return sourceDir;
    }

    private static File prepareOutputDir(HelmConfig helmConfig, HelmConfig.HelmType type) throws IOException {
        File outputDir = new File(helmConfig.getOutputDir(), type.getOutputDir());
        if (outputDir.exists() && !outputDir.isDirectory()) {
            FileUtils.forceDelete((File)outputDir);
        }
        FileUtils.forceMkdir((File)outputDir);
        return outputDir;
    }

    public static boolean isYaml(File file) {
        return file.getName().toLowerCase().matches(".*?\\.ya?ml$");
    }

    public static List<File> listYamls(File directory) {
        return Stream.of((Object[])Optional.ofNullable(directory.listFiles()).orElse(new File[0])).filter(File::isFile).filter(HelmService::isYaml).collect(Collectors.toList());
    }

    public static boolean containsYamlFiles(File directory) {
        return !HelmService.listYamls(directory).isEmpty();
    }

    private static void processSourceFiles(File sourceDir, File templatesDir) throws IOException {
        for (File file : HelmService.listYamls(sourceDir)) {
            KubernetesResource dto = (KubernetesResource)ResourceUtil.load((File)file, KubernetesResource.class, (ResourceFileType)ResourceFileType.yaml);
            if (dto instanceof Template) {
                HelmService.splitAndSaveTemplate((Template)dto, templatesDir);
                continue;
            }
            String fileName = FileUtil.stripPostfix((String)file.getName(), (String)".yml") + YAML_EXTENSION;
            File targetFile = new File(templatesDir, fileName);
            String text = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
            text = TemplateUtil.escapeYamlTemplate((String)text);
            FileUtils.write((File)targetFile, (CharSequence)text, (Charset)Charset.defaultCharset());
        }
    }

    private static void splitAndSaveTemplate(Template template, File templatesDir) throws IOException {
        for (HasMetadata object : Optional.ofNullable(template.getObjects()).orElse(Collections.emptyList())) {
            String name = KubernetesResourceUtil.getNameWithSuffix((String)KubernetesHelper.getName((HasMetadata)object), (String)KubernetesHelper.getKind((HasMetadata)object)) + YAML_EXTENSION;
            File outFile = new File(templatesDir, name);
            ResourceUtil.save((File)outFile, (Object)object);
        }
    }

    static void createChartYaml(HelmConfig helmConfig, File outputDir) throws IOException {
        Chart chart = new Chart();
        chart.setName(helmConfig.getChart());
        chart.setVersion(helmConfig.getVersion());
        chart.setDescription(helmConfig.getDescription());
        chart.setHome(helmConfig.getHome());
        chart.setSources(helmConfig.getSources());
        chart.setMaintainers(helmConfig.getMaintainers());
        chart.setIcon(helmConfig.getIcon());
        chart.setKeywords(helmConfig.getKeywords());
        chart.setEngine(helmConfig.getEngine());
        File outputChartFile = new File(outputDir, CHART_FILENAME);
        ResourceUtil.save((File)outputChartFile, (Object)chart, (ResourceFileType)ResourceFileType.yaml);
    }

    private static void copyAdditionalFiles(HelmConfig helmConfig, File outputDir) throws IOException {
        for (File additionalFile : Optional.ofNullable(helmConfig.getAdditionalFiles()).orElse(Collections.emptyList())) {
            FileUtils.copyFile((File)additionalFile, (File)new File(outputDir, additionalFile.getName()));
        }
    }

    private static String interpolateTemplateWithHelmParameter(String template, HelmParameter parameter) {
        String name = parameter.getParameter().getName();
        String from = "${" + name + "}";
        String answer = template;
        String defaultExpression = "";
        String required = "";
        String value = parameter.getParameter().getValue();
        if (value != null) {
            defaultExpression = " | default \"" + value + "\"";
        }
        if (Boolean.TRUE.equals(parameter.getParameter().getRequired())) {
            required = "required \"A valid .Values." + parameter.getHelmName() + " entry required!\" ";
        }
        String to = "{{ " + required + ".Values." + parameter.getHelmName() + defaultExpression + " }}";
        answer = answer.replace(from, to);
        from = "$" + name;
        return answer.replace(from, to);
    }

    private static void interpolateTemplateParameterExpressionsWithHelmExpressions(File file, List<HelmParameter> helmParameters) throws IOException {
        String originalTemplate;
        String interpolatedTemplate = originalTemplate = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        for (HelmParameter helmParameter : helmParameters) {
            interpolatedTemplate = HelmService.interpolateTemplateWithHelmParameter(interpolatedTemplate, helmParameter);
        }
        if (!originalTemplate.equals(interpolatedTemplate)) {
            FileUtils.writeStringToFile((File)file, (String)interpolatedTemplate, (Charset)Charset.defaultCharset());
        }
    }

    private static void createTemplateParameters(HelmConfig helmConfig, File outputDir, File templatesDir) throws IOException {
        List<HelmParameter> helmParameters = Optional.ofNullable(helmConfig.getTemplates()).orElse(Collections.emptyList()).stream().map(Template::getParameters).flatMap(Collection::stream).map(HelmParameter::new).collect(Collectors.toList());
        Map<String, String> values = helmParameters.stream().collect(Collectors.toMap(HelmParameter::getHelmName, hp -> hp.getParameter().getValue()));
        File outputChartFile = new File(outputDir, VALUES_FILENAME);
        ResourceUtil.save((File)outputChartFile, values, (ResourceFileType)ResourceFileType.yaml);
        for (File file : HelmService.listYamls(templatesDir)) {
            HelmService.interpolateTemplateParameterExpressionsWithHelmExpressions(file, helmParameters);
        }
    }
}

