/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm.oci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jkube.kit.resource.helm.oci.OCIManifestLayer;

public class OCIManifest {
    private int schemaVersion;
    private OCIManifestLayer config;
    private List<OCIManifestLayer> layers;

    public static OCIManifestBuilder builder() {
        return new OCIManifestBuilder();
    }

    public OCIManifestBuilder toBuilder() {
        OCIManifestBuilder builder = new OCIManifestBuilder().schemaVersion(this.schemaVersion).config(this.config);
        if (this.layers != null) {
            builder.layers(this.layers);
        }
        return builder;
    }

    public OCIManifest(int schemaVersion, OCIManifestLayer config, List<OCIManifestLayer> layers) {
        this.schemaVersion = schemaVersion;
        this.config = config;
        this.layers = layers;
    }

    public OCIManifest() {
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public OCIManifestLayer getConfig() {
        return this.config;
    }

    public List<OCIManifestLayer> getLayers() {
        return this.layers;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setConfig(OCIManifestLayer config) {
        this.config = config;
    }

    public void setLayers(List<OCIManifestLayer> layers) {
        this.layers = layers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OCIManifest)) {
            return false;
        }
        OCIManifest other = (OCIManifest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSchemaVersion() != other.getSchemaVersion()) {
            return false;
        }
        OCIManifestLayer this$config = this.getConfig();
        OCIManifestLayer other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        List<OCIManifestLayer> this$layers = this.getLayers();
        List<OCIManifestLayer> other$layers = other.getLayers();
        return !(this$layers == null ? other$layers != null : !((Object)this$layers).equals(other$layers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OCIManifest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSchemaVersion();
        OCIManifestLayer $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        List<OCIManifestLayer> $layers = this.getLayers();
        result = result * 59 + ($layers == null ? 43 : ((Object)$layers).hashCode());
        return result;
    }

    public static class OCIManifestBuilder {
        private int schemaVersion;
        private OCIManifestLayer config;
        private ArrayList<OCIManifestLayer> layers;

        OCIManifestBuilder() {
        }

        public OCIManifestBuilder schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public OCIManifestBuilder config(OCIManifestLayer config) {
            this.config = config;
            return this;
        }

        public OCIManifestBuilder layer(OCIManifestLayer layer) {
            if (this.layers == null) {
                this.layers = new ArrayList();
            }
            this.layers.add(layer);
            return this;
        }

        public OCIManifestBuilder layers(Collection<? extends OCIManifestLayer> layers) {
            if (layers == null) {
                throw new NullPointerException("layers cannot be null");
            }
            if (this.layers == null) {
                this.layers = new ArrayList();
            }
            this.layers.addAll(layers);
            return this;
        }

        public OCIManifestBuilder clearLayers() {
            if (this.layers != null) {
                this.layers.clear();
            }
            return this;
        }

        public OCIManifest build() {
            List<OCIManifestLayer> layers;
            switch (this.layers == null ? 0 : this.layers.size()) {
                case 0: {
                    layers = Collections.emptyList();
                    break;
                }
                case 1: {
                    layers = Collections.singletonList(this.layers.get(0));
                    break;
                }
                default: {
                    layers = Collections.unmodifiableList(new ArrayList<OCIManifestLayer>(this.layers));
                }
            }
            return new OCIManifest(this.schemaVersion, this.config, layers);
        }

        public String toString() {
            return "OCIManifest.OCIManifestBuilder(schemaVersion=" + this.schemaVersion + ", config=" + this.config + ", layers=" + this.layers + ")";
        }
    }
}

