/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.resource.helm.BadUploadException;
import org.eclipse.jkube.kit.resource.helm.HelmRepository;

public class HelmUploader {
    private KitLogger logger;

    public HelmUploader(KitLogger logger) {
        this.logger = logger;
    }

    protected void uploadSingle(File file, HelmRepository repository) throws IOException, BadUploadException {
        if (repository.getType() == null) {
            throw new IllegalArgumentException("Repository type missing. Check your plugin configuration.");
        }
        HttpURLConnection connection = repository.getType().createConnection(file, repository);
        this.writeFileOnConnection(file, connection);
        if (connection.getResponseCode() >= 300) {
            String response = connection.getErrorStream() != null ? IOUtils.toString((InputStream)connection.getErrorStream(), (Charset)Charset.defaultCharset()) : (connection.getInputStream() != null ? IOUtils.toString((InputStream)connection.getInputStream(), (Charset)Charset.defaultCharset()) : "No details provided");
            throw new BadUploadException(response);
        }
        String message = Integer.toString(connection.getResponseCode());
        if (connection.getInputStream() != null) {
            message = message + " - " + IOUtils.toString((InputStream)connection.getInputStream(), (Charset)Charset.defaultCharset());
        }
        this.logger.info(message, new Object[0]);
        connection.disconnect();
    }

    protected void writeFileOnConnection(File file, HttpURLConnection connection) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)connection.getOutputStream());
        }
    }
}

