/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot.watcher;

import com.google.common.io.Closeables;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.PrefixedLogger;
import org.eclipse.jkube.kit.common.util.ClassUtil;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.IoUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.SpringBootConfigurationHelper;
import org.eclipse.jkube.kit.common.util.SpringBootUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.service.PodLogService;
import org.eclipse.jkube.kit.config.service.PortForwardService;
import org.eclipse.jkube.watcher.api.BaseWatcher;
import org.eclipse.jkube.watcher.api.WatcherContext;

public class SpringBootWatcher
extends BaseWatcher {
    private final PortForwardService portForwardService;
    private final Runtime runtime;

    public SpringBootWatcher(WatcherContext watcherContext) {
        this(Runtime.getRuntime(), watcherContext);
    }

    SpringBootWatcher(Runtime runtime, WatcherContext watcherContext) {
        super(watcherContext, "spring-boot");
        this.portForwardService = new PortForwardService(watcherContext.getLogger());
        this.runtime = runtime;
    }

    public boolean isApplicable(List<ImageConfiguration> configs, Collection<HasMetadata> resources, PlatformMode mode) {
        return JKubeProjectUtil.hasPluginOfAnyArtifactId((JavaProject)this.getContext().getBuildContext().getProject(), (String)"spring-boot-maven-plugin") || JKubeProjectUtil.hasPluginOfAnyArtifactId((JavaProject)this.getContext().getBuildContext().getProject(), (String)"org.springframework.boot.gradle.plugin");
    }

    public void watch(List<ImageConfiguration> configs, String namespace, Collection<HasMetadata> resources, PlatformMode mode) throws Exception {
        NamespacedKubernetesClient kubernetes = namespace != null ? ((NamespacedKubernetesClient)this.getContext().getJKubeServiceHub().getClient().adapt(NamespacedKubernetesClient.class)).inNamespace(namespace) : (NamespacedKubernetesClient)this.getContext().getJKubeServiceHub().getClient().adapt(NamespacedKubernetesClient.class);
        PodLogService.PodLogServiceContext logContext = PodLogService.PodLogServiceContext.builder().log((KitLogger)this.log).newPodLog(this.getContext().getNewPodLogger()).oldPodLog(this.getContext().getOldPodLogger()).build();
        new PodLogService(logContext).tailAppPodsLogs((KubernetesClient)kubernetes, namespace, resources, false, null, true, null, false);
        String url = this.getPortForwardUrl(kubernetes, resources);
        if (url == null) {
            throw new IllegalStateException("Unable to open a channel to the remote pod.");
        }
        this.runRemoteSpringApplication(url);
    }

    String getPortForwardUrl(NamespacedKubernetesClient kubernetes, Collection<HasMetadata> resources) {
        LabelSelector selector = KubernetesHelper.extractPodLabelSelector(resources);
        if (selector == null) {
            this.log.warn("Unable to determine a selector for application pods", new Object[0]);
            return null;
        }
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((URLClassLoader)JKubeProjectUtil.getClassLoader((JavaProject)this.getContext().getBuildContext().getProject()));
        SpringBootConfigurationHelper propertyHelper = new SpringBootConfigurationHelper(SpringBootUtil.getSpringBootVersion((JavaProject)this.getContext().getBuildContext().getProject()));
        int localHostPort = IoUtil.getFreeRandomPort();
        int containerPort = propertyHelper.getServerPort(properties);
        this.portForwardService.forwardPortAsync(kubernetes, selector, containerPort, localHostPort);
        return this.createForwardUrl(propertyHelper, properties, localHostPort);
    }

    private String createForwardUrl(SpringBootConfigurationHelper propertyHelper, Properties properties, int localPort) {
        String scheme = StringUtils.isNotBlank((CharSequence)properties.getProperty(propertyHelper.getServerKeystorePropertyKey())) ? "https://" : "http://";
        String contextPath = properties.getProperty(propertyHelper.getServerContextPathPropertyKey(), "");
        return scheme + "localhost:" + localPort + contextPath;
    }

    private void runRemoteSpringApplication(String url) {
        this.log.info("Running RemoteSpringApplication against endpoint: " + url, new Object[0]);
        String remoteSecret = this.validateSpringBootDevtoolsSettings();
        ArrayList<URLClassLoader> classLoaders = new ArrayList<URLClassLoader>();
        ClassLoader pluginClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (pluginClassLoader instanceof URLClassLoader) {
            classLoaders.add((URLClassLoader)pluginClassLoader);
        }
        try (URLClassLoader projectClassLoader = ClassUtil.createProjectClassLoader((List)this.getContext().getBuildContext().getProject().getCompileClassPathElements(), (KitLogger)this.log);){
            String devToolsPath;
            classLoaders.add(projectClassLoader);
            try {
                devToolsPath = this.getSpringBootDevToolsJar(this.getContext().getBuildContext().getProject()).getCanonicalPath();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to include devtools in the classpath: " + e, e);
            }
            String classPath = classLoaders.stream().flatMap(cl -> Stream.of(cl.getURLs())).map(u -> {
                try {
                    URI uri = u.toURI();
                    File file = new File(uri);
                    return file.getCanonicalPath();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to create classpath: " + e, e);
                }
            }).collect(Collectors.joining(File.pathSeparator, "", File.pathSeparator)).concat(devToolsPath);
            CharSequence[] command = new String[]{SpringBootWatcher.javaBinary(), "-cp", classPath, "-Dspring.devtools.remote.secret=" + remoteSecret, "org.springframework.boot.devtools.RemoteSpringApplication", url};
            try {
                this.log.debug("Running: " + String.join((CharSequence)" ", command), new Object[0]);
                final Process process = this.runtime.exec((String[])command);
                final AtomicBoolean outputEnabled = new AtomicBoolean(true);
                this.runtime.addShutdownHook(new Thread("jkube:watch [spring-boot] shutdown hook"){

                    @Override
                    public void run() {
                        SpringBootWatcher.this.log.info("Terminating the Spring remote client...", new Object[0]);
                        outputEnabled.set(false);
                        process.destroy();
                    }
                });
                PrefixedLogger logger = new PrefixedLogger("Spring-Remote", (KitLogger)this.log);
                Thread stdOutPrinter = this.startOutputProcessor((KitLogger)logger, process.getInputStream(), false, outputEnabled);
                Thread stdErrPrinter = this.startOutputProcessor((KitLogger)logger, process.getErrorStream(), true, outputEnabled);
                int status = process.waitFor();
                stdOutPrinter.join();
                stdErrPrinter.join();
                if (status != 0) {
                    this.log.warn("Process returned status: %s", new Object[]{status});
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to run RemoteSpringApplication: " + e, e);
            }
        }
        catch (IOException e) {
            this.log.warn("Instructed to use project classpath, but cannot. Continuing build if we can: ", new Object[]{e});
        }
    }

    protected Thread startOutputProcessor(final KitLogger logger, final InputStream inputStream, final boolean error, final AtomicBoolean outputEnabled) {
        Thread printer = new Thread(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!outputEnabled.get()) continue;
                        if (error) {
                            logger.error("%s", new Object[]{line});
                            continue;
                        }
                        logger.info("%s", new Object[]{line});
                    }
                }
                catch (Exception e) {
                    if (outputEnabled.get()) {
                        logger.error("Failed to process " + (error ? "stderr" : "stdout") + " from spring-remote process: " + e, new Object[0]);
                    }
                }
                finally {
                    Closeables.closeQuietly((Reader)reader);
                }
            }
        };
        printer.start();
        return printer;
    }

    private File getSpringBootDevToolsJar(JavaProject project) {
        String version = (String)SpringBootUtil.getSpringBootDevToolsVersion((JavaProject)project).orElseThrow(() -> new IllegalStateException("Unable to find the spring-boot version"));
        return JKubeProjectUtil.resolveArtifact((JavaProject)this.getContext().getBuildContext().getProject(), (String)"org.springframework.boot", (String)"spring-boot-devtools", (String)version, (String)"jar");
    }

    private String validateSpringBootDevtoolsSettings() {
        Map configuration = SpringBootUtil.getSpringBootPluginConfiguration((JavaProject)this.getContext().getBuildContext().getProject());
        if (!(configuration == null || configuration.containsKey("excludeDevtools") && configuration.get("excludeDevtools").equals("false"))) {
            this.log.warn("devtools need to be included in repacked archive, please set <excludeDevtools> to false in plugin configuration", new Object[0]);
            throw new IllegalStateException("devtools needs to be included in fat jar");
        }
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((URLClassLoader)JKubeProjectUtil.getClassLoader((JavaProject)this.getContext().getBuildContext().getProject()));
        String remoteSecret = properties.getProperty("spring.devtools.remote.secret", System.getProperty("spring.devtools.remote.secret"));
        if (StringUtils.isBlank((CharSequence)remoteSecret)) {
            this.log.warn("There is no `%s` property defined in your src/main/resources/application.properties. Please add one!", new Object[]{"spring.devtools.remote.secret"});
            throw new IllegalStateException("No spring.devtools.remote.secret property defined in application.properties or system properties");
        }
        return properties.getProperty("spring.devtools.remote.secret");
    }

    private static String javaBinary() {
        String path = new File(System.getProperty("java.home")).toPath().resolve("bin").resolve("java").toFile().getAbsolutePath();
        if (EnvUtil.isWindows()) {
            path = path.concat(".exe");
        }
        return path;
    }
}

