/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jkube.generator.api.GeneratorConfig;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.springboot.SpringBootLayeredJar;
import org.eclipse.jkube.springboot.generator.AbstractSpringBootNestedGenerator;

public class LayeredJarGenerator
extends AbstractSpringBootNestedGenerator {
    private final SpringBootLayeredJar springBootLayeredJar;

    public LayeredJarGenerator(GeneratorContext generatorContext, GeneratorConfig generatorConfig, File layeredJar) {
        super(generatorContext, generatorConfig);
        this.springBootLayeredJar = new SpringBootLayeredJar(layeredJar, this.getLogger());
    }

    @Override
    public Map<String, String> getEnv(Function<Boolean, Map<String, String>> javaExecEnvSupplier, boolean prePackagePhase) {
        Map<String, String> res = super.getEnv(javaExecEnvSupplier, prePackagePhase);
        res.put("JAVA_MAIN_CLASS", this.springBootLayeredJar.getMainClass());
        return res;
    }

    @Override
    public AssemblyConfiguration createAssemblyConfiguration(List<AssemblyFileSet> defaultFileSets) {
        this.getLogger().info("Spring Boot layered jar detected", new Object[0]);
        ArrayList<Assembly> layerAssemblies = new ArrayList<Assembly>();
        layerAssemblies.add(Assembly.builder().id("jkube-includes").fileSets(defaultFileSets).build());
        this.springBootLayeredJar.extractLayers(this.getProject().getBuildPackageDirectory());
        for (String springBootLayer : this.springBootLayeredJar.listLayers()) {
            File layerDir = new File(this.getProject().getBuildPackageDirectory(), springBootLayer);
            layerAssemblies.add(Assembly.builder().id(springBootLayer).fileSet(AssemblyFileSet.builder().outputDirectory(new File(".")).directory(FileUtil.getRelativePath((File)this.getProject().getBaseDirectory(), (File)layerDir)).exclude("*").fileMode("0640").build()).build());
        }
        return AssemblyConfiguration.builder().targetDir(this.getTargetDir()).excludeFinalOutputArtifact(true).layers(layerAssemblies).build();
    }
}

