/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot;

import org.eclipse.jkube.kit.common.ExternalCommand;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.PrefixedLogger;
import org.eclipse.jkube.kit.common.util.EnvUtil;

public class RemoteSpringBootDevtoolsCommand
extends ExternalCommand {
    private final String classPath;
    private final String remoteSecret;
    private final String url;
    private final KitLogger processLogger;

    public RemoteSpringBootDevtoolsCommand(String classPath, String remoteSecret, String url, KitLogger kitLogger) {
        super(kitLogger);
        this.classPath = classPath;
        this.remoteSecret = remoteSecret;
        this.url = url;
        this.processLogger = new PrefixedLogger("Spring-Remote", kitLogger);
    }

    protected void start() {
        this.log.debug("Running: " + String.join((CharSequence)" ", this.getCommandAsString()), new Object[0]);
    }

    protected String[] getArgs() {
        return new String[]{EnvUtil.javaBinary(), "-cp", this.classPath, "-Dspring.devtools.remote.secret=" + this.remoteSecret, "org.springframework.boot.devtools.RemoteSpringApplication", this.url};
    }

    protected void processLine(String line) {
        this.processLogger.info("%s", new Object[]{line});
    }

    protected void processError(String line) {
        this.processLogger.error("%s", new Object[]{line});
    }

    protected void end() {
        if (this.getStatusCode() != 0) {
            this.log.warn("Process returned status: %s", new Object[]{this.getStatusCode()});
        }
        this.log.info("Terminating the Spring remote client...", new Object[0]);
    }
}

