/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot.generator;

import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.GeneratorMode;
import org.eclipse.jkube.generator.javaexec.JavaExecGenerator;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.SpringBootConfiguration;
import org.eclipse.jkube.kit.common.util.SpringBootUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.springboot.SpringBootDevtoolsUtils;
import org.eclipse.jkube.springboot.generator.SpringBootNestedGenerator;

public class SpringBootGenerator
extends JavaExecGenerator {
    private final SpringBootNestedGenerator nestedGenerator;

    public SpringBootGenerator(GeneratorContext context) {
        super(context, "spring-boot");
        this.nestedGenerator = SpringBootNestedGenerator.from(context, this.getGeneratorConfig(), this.detectFatJar());
        Properties springBootApplicationConfig = SpringBootUtil.getSpringBootApplicationProperties((String)SpringBootUtil.getSpringBootActiveProfile((JavaProject)this.getContext().getProject()), (URLClassLoader)JKubeProjectUtil.getClassLoader((JavaProject)this.getContext().getProject()));
        this.log.debug("Spring Boot Application Config loaded from: %s", new Object[]{springBootApplicationConfig.get("jkube.internal.application-config-file.path")});
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && (JKubeProjectUtil.hasPluginOfAnyArtifactId((JavaProject)this.getProject(), (String)"spring-boot-maven-plugin") || JKubeProjectUtil.hasPluginOfAnyArtifactId((JavaProject)this.getProject(), (String)"org.springframework.boot.gradle.plugin"));
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean isPrePackagePhase) {
        if (this.getContext().getGeneratorMode() == GeneratorMode.WATCH) {
            boolean isDevtoolsSecretPresent = SpringBootDevtoolsUtils.ensureSpringDevToolSecretToken(this.getProject());
            if (!isDevtoolsSecretPresent) {
                this.log.verbose("Generating the spring devtools token in property: spring.devtools.remote.secret", new Object[0]);
                throw new IllegalStateException("No spring.devtools.remote.secret found in application.properties. Plugin has added it, please re-run goals");
            }
            if (!isPrePackagePhase && this.isFatJar()) {
                SpringBootDevtoolsUtils.addDevToolsFilesToFatJar(this.getProject(), this.detectFatJar());
            }
        }
        return super.customize(configs, isPrePackagePhase);
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) {
        return this.nestedGenerator.getEnv(ppp -> super.getEnv(ppp.booleanValue()), prePackagePhase);
    }

    protected List<String> getExtraJavaOptions() {
        List opts = super.getExtraJavaOptions();
        String configuredColor = this.getConfig(Config.COLOR);
        if (StringUtils.isNotBlank((CharSequence)configuredColor)) {
            opts.add("-Dspring.output.ansi.enabled=" + configuredColor);
        }
        return opts;
    }

    protected boolean isFatJar() {
        if (!this.hasMainClass() && SpringBootUtil.isSpringBootRepackage((JavaProject)this.getProject())) {
            this.log.verbose("Using fat jar packaging as the spring boot plugin is using `repackage` goal execution", new Object[0]);
            return true;
        }
        return super.isFatJar();
    }

    protected String getDefaultWebPort() {
        return "" + SpringBootConfiguration.from((JavaProject)this.getProject()).getServerPort();
    }

    protected AssemblyConfiguration createAssembly() {
        return Optional.ofNullable(this.nestedGenerator.createAssemblyConfiguration(this.addAdditionalFiles())).orElse(super.createAssembly());
    }

    protected String getBuildWorkdir() {
        return this.nestedGenerator.getBuildWorkdir();
    }

    protected String getFromAsConfigured() {
        return Optional.ofNullable(super.getFromAsConfigured()).orElse(this.nestedGenerator.getFrom());
    }

    protected Arguments getBuildEntryPoint() {
        return this.nestedGenerator.getBuildEntryPoint();
    }

    protected String getDefaultJolokiaPort() {
        return this.nestedGenerator.getDefaultJolokiaPort();
    }

    protected String getDefaultPrometheusPort() {
        return this.nestedGenerator.getDefaultPrometheusPort();
    }

    public static enum Config implements Configs.Config
    {
        COLOR("color", "");

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

