/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.thorntail.v2.enricher;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.ThorntailUtil;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.specific.AbstractHealthCheckEnricher;

public class ThorntailV2HealthCheckEnricher
extends AbstractHealthCheckEnricher {
    private static final String IO_THORNTAIL = "io.thorntail";

    public ThorntailV2HealthCheckEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-healthcheck-thorntail-v2");
    }

    protected Probe getReadinessProbe() {
        return this.discoverThorntailHealthCheck(10);
    }

    protected Probe getLivenessProbe() {
        return this.discoverThorntailHealthCheck(180);
    }

    private Probe discoverThorntailHealthCheck(int initialDelay) {
        if (this.getContext().hasDependency(IO_THORNTAIL, "thorntail-kernel")) {
            return null;
        }
        if (this.getContext().hasDependency(IO_THORNTAIL, "monitor") || this.getContext().hasDependency(IO_THORNTAIL, "microprofile-health")) {
            Integer port = this.getPort();
            String scheme = this.getScheme().toUpperCase();
            String path = this.getPath();
            return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(port)).withPath(path)).withScheme(scheme)).endHttpGet()).withFailureThreshold(Integer.valueOf(this.getFailureThreshold()))).withSuccessThreshold(Integer.valueOf(this.getSuccessThreshold()))).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
        }
        return null;
    }

    protected int getFailureThreshold() {
        return Configs.asInteger((String)this.getConfig(Config.FAILURE_THRESHOLD));
    }

    protected int getSuccessThreshold() {
        return Configs.asInteger((String)this.getConfig(Config.SUCCESS_THRESHOLD));
    }

    protected String getScheme() {
        return this.getConfig(Config.SCHEME);
    }

    protected int getPort() {
        Properties properties = ThorntailUtil.getThorntailProperties((URLClassLoader)this.getContext().getProjectClassLoaders().getCompileClassLoader());
        properties.putAll((Map<?, ?>)System.getProperties());
        if (properties.containsKey("thorntail.http.port")) {
            return Integer.parseInt((String)properties.get("thorntail.http.port"));
        }
        return Configs.asInt((String)this.getConfig(Config.PORT));
    }

    protected String getPath() {
        return this.getConfig(Config.PATH);
    }

    private static enum Config implements Configs.Config
    {
        SCHEME("scheme", "HTTP"),
        PORT("port", "8080"),
        FAILURE_THRESHOLD("failureThreshold", "3"),
        SUCCESS_THRESHOLD("successThreshold", "1"),
        PATH("path", "/health");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

