/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.vertx.enricher;

import io.fabric8.kubernetes.api.model.HTTPHeader;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.specific.AbstractHealthCheckEnricher;

public class VertxHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    private static final String ENRICHER_NAME = "jkube-healthcheck-vertx";
    private static final String READINESS = "readiness";
    private static final String LIVENESS = "liveness";
    static final String VERTX_MAVEN_PLUGIN_GROUP = "io.reactiverse";
    static final String VERTX_MAVEN_PLUGIN_ARTIFACT = "vertx-maven-plugin";
    static final String VERTX_GROUPID = "io.vertx";
    private static final int DEFAULT_MANAGEMENT_PORT = 8080;
    private static final String SCHEME_HTTP = "HTTP";
    private static final String VERTX_HEALTH = "vertx.health.";
    private static final Function<? super String, String> TRIM = input -> input == null ? null : input.trim();
    protected static final String[] JKUBE_PLUGINS = new String[]{"kubernetes-maven-plugin", "openshift-maven-plugin"};
    public static final String ERROR_MESSAGE = "Location of %s should return a String but found %s with value %s";

    public VertxHealthCheckEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, ENRICHER_NAME);
    }

    protected Probe getReadinessProbe() {
        return this.discoverVertxHealthCheck(true);
    }

    protected Probe getLivenessProbe() {
        return this.discoverVertxHealthCheck(false);
    }

    private boolean isApplicable() {
        return this.getContext().hasPlugin(VERTX_MAVEN_PLUGIN_GROUP, VERTX_MAVEN_PLUGIN_ARTIFACT) || this.getContext().hasDependency(VERTX_GROUPID, null);
    }

    private String getSpecificPropertyName(boolean readiness, Config config) {
        if (readiness) {
            return "vertx.health.readiness." + config.getKey();
        }
        return "vertx.health.liveness." + config.getKey();
    }

    private Probe discoverVertxHealthCheck(boolean readiness) {
        if (!this.isApplicable()) {
            return null;
        }
        String type = this.getStringValue(Config.TYPE, readiness).orElse("http").toUpperCase();
        Optional<Integer> port = this.getIntegerValue(Config.PORT, readiness);
        Optional<String> portName = this.getStringValue(Config.PORT_NAME, readiness);
        String path = this.getStringValue(Config.PATH, readiness).map(input -> {
            if (input.isEmpty() || input.startsWith("/")) {
                return input;
            }
            return "/" + input;
        }).orElse(null);
        String scheme = this.getStringValue(Config.SCHEME, readiness).orElse(SCHEME_HTTP).toUpperCase();
        Optional<Integer> initialDelay = this.getIntegerValue(Config.INITIAL_DELAY, readiness);
        Optional<Integer> period = this.getIntegerValue(Config.PERIOD, readiness);
        Optional<Integer> timeout = this.getIntegerValue(Config.TIMEOUT, readiness);
        Optional<Integer> successThreshold = this.getIntegerValue(Config.SUCCESS_THRESHOLD, readiness);
        Optional<Integer> failureThreshold = this.getIntegerValue(Config.FAILURE_THRESHOLD, readiness);
        List command = this.getListValue(Config.COMMAND, readiness).orElse(Collections.emptyList());
        Map headers = this.getMapValue(Config.HEADERS, readiness).orElse(Collections.emptyMap());
        if (port.isPresent() && portName.isPresent()) {
            this.log.error("Invalid health check configuration - both 'port' and 'port-name' are set, only one of them can be used", new Object[0]);
            throw new IllegalArgumentException("Invalid health check configuration - both 'port' and 'port-name' are set, only one of them can be used");
        }
        if (type.equalsIgnoreCase("TCP")) {
            if (!port.isPresent() && !portName.isPresent()) {
                this.log.info("TCP health check disabled (port not set)", new Object[0]);
                return null;
            }
            if (port.isPresent() && port.get() <= 0) {
                this.log.info("TCP health check disabled (port set to a negative number)", new Object[0]);
                return null;
            }
        } else if (type.equalsIgnoreCase("EXEC")) {
            if (command.isEmpty()) {
                this.log.info("TCP health check disabled (command not set)", new Object[0]);
                return null;
            }
        } else if (type.equalsIgnoreCase(SCHEME_HTTP)) {
            if (port.isPresent() && port.get() <= 0) {
                this.log.info("HTTP health check disabled (port set to " + port.get(), new Object[0]);
                return null;
            }
            if (path == null) {
                this.log.info("HTTP health check disabled (path not set)", new Object[0]);
                return null;
            }
            if (path.isEmpty()) {
                this.log.info("HTTP health check disabled (the path is empty)", new Object[0]);
                return null;
            }
            if (!port.isPresent() && !portName.isPresent()) {
                this.log.info("Using default management port (8080) for HTTP health check probe", new Object[0]);
                port = Optional.of(8080);
            }
        } else {
            this.log.error("Invalid health check configuration - Unknown probe type, only 'exec', 'tcp' and 'http' (default) are supported", new Object[0]);
            throw new IllegalArgumentException("Invalid health check configuration - Unknown probe type, only 'exec', 'tcp' and 'http' (default) are supported");
        }
        ProbeBuilder builder = new ProbeBuilder();
        initialDelay.ifPresent(arg_0 -> ((ProbeBuilder)builder).withInitialDelaySeconds(arg_0));
        period.ifPresent(arg_0 -> ((ProbeBuilder)builder).withPeriodSeconds(arg_0));
        timeout.ifPresent(arg_0 -> ((ProbeBuilder)builder).withTimeoutSeconds(arg_0));
        successThreshold.ifPresent(arg_0 -> ((ProbeBuilder)builder).withSuccessThreshold(arg_0));
        failureThreshold.ifPresent(arg_0 -> ((ProbeBuilder)builder).withFailureThreshold(arg_0));
        switch (type) {
            case "HTTP": {
                ProbeFluent.HttpGetNested http = (ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)builder.withNewHttpGet().withScheme(scheme)).withPath(path);
                port.ifPresent(arg_0 -> ((ProbeFluent.HttpGetNested)http).withNewPort(arg_0));
                portName.ifPresent(arg_0 -> ((ProbeFluent.HttpGetNested)http).withNewPort(arg_0));
                if (!headers.isEmpty()) {
                    ArrayList<HTTPHeader> list = new ArrayList<HTTPHeader>();
                    for (Map.Entry entry : headers.entrySet()) {
                        list.add(new HTTPHeader((String)entry.getKey(), (String)entry.getValue()));
                    }
                    http.withHttpHeaders(list);
                }
                http.endHttpGet();
                break;
            }
            case "TCP": {
                ProbeFluent.TcpSocketNested tcp = builder.withNewTcpSocket();
                port.ifPresent(arg_0 -> ((ProbeFluent.TcpSocketNested)tcp).withNewPort(arg_0));
                portName.ifPresent(arg_0 -> ((ProbeFluent.TcpSocketNested)tcp).withNewPort(arg_0));
                tcp.endTcpSocket();
                break;
            }
            case "EXEC": {
                ((ProbeFluent.ExecNested)builder.withNewExec().withCommand(command)).endExec();
            }
        }
        return builder.build();
    }

    private Optional<String> getStringValue(Config config, boolean readiness) {
        Optional<String> specificValue = this.getSpecificValueFromConfigOrProperties(config, readiness);
        if (specificValue.isPresent()) {
            return specificValue.map(TRIM);
        }
        return this.getGenericValueFromConfigOrProperties(config).map(TRIM);
    }

    private Optional<String> getSpecificValueFromConfigOrProperties(Config config, boolean readiness) {
        Optional<String> configValue = this.getElementAsString(readiness ? READINESS : LIVENESS, config.getKey());
        if (configValue.isPresent()) {
            return configValue;
        }
        return Optional.ofNullable(Configs.getFromSystemPropertyWithPropertiesAsFallback((Properties)this.enricherContext.getProperties(), (String)this.getSpecificPropertyName(readiness, config)));
    }

    private Optional<String> getGenericValueFromConfigOrProperties(Config config) {
        return Optional.ofNullable(this.getConfigWithFallback(config, VERTX_HEALTH + config.getKey(), null));
    }

    private Optional<List<String>> getListValue(Config config, boolean readiness) {
        Optional<Object> element = this.getElement(readiness ? READINESS : LIVENESS, config.getKey());
        if (!element.isPresent()) {
            element = this.getElement(config.getKey());
        }
        return element.map(input -> {
            if (input instanceof Map) {
                Collection values = ((Map)input).values();
                ArrayList<String> elements = new ArrayList<String>();
                for (Object value : values) {
                    if (value instanceof List) {
                        List currentValues = (List)value;
                        elements.addAll(currentValues);
                        continue;
                    }
                    elements.add((String)value);
                }
                return elements;
            }
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, config.getKey(), input.getClass(), input.toString()));
        });
    }

    private Optional<Map<String, String>> getMapValue(Config config, boolean readiness) {
        Optional<Object> element = this.getElement(readiness ? READINESS : LIVENESS, config.getKey());
        if (!element.isPresent()) {
            element = this.getElement(config.getKey());
        }
        return element.map(input -> {
            if (input instanceof Map) {
                return (Map)input;
            }
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, config.getKey(), input.getClass(), input.toString()));
        });
    }

    private Optional<Integer> getIntegerValue(Config config, boolean readiness) {
        return this.getStringValue(config, readiness).map(Integer::parseInt);
    }

    private Optional<String> getElementAsString(String ... keys) {
        return this.getElement(keys).map(input -> {
            if (input instanceof String) {
                return (String)input;
            }
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, Arrays.toString(keys), input.getClass(), input.toString()));
        });
    }

    private Optional<Object> getElement(String ... path) {
        Optional<Map<String, Object>> configuration = this.getMavenPluginConfiguration();
        if (!configuration.isPresent()) {
            return Optional.empty();
        }
        String[] roots = new String[]{"enricher", "config", ENRICHER_NAME};
        ArrayList<String> absolute = new ArrayList<String>();
        absolute.addAll(Arrays.asList(roots));
        absolute.addAll(Arrays.asList(path));
        Object root = configuration.get();
        for (String key : absolute) {
            Map<String, Object> rootMap;
            if (!(root instanceof Map) || (root = (rootMap = root).get(key)) != null) continue;
            return Optional.empty();
        }
        return Optional.of(root);
    }

    private Optional<Map<String, Object>> getMavenPluginConfiguration() {
        for (String pluginId : JKUBE_PLUGINS) {
            Optional configuration = this.getContext().getConfiguration().getPluginConfiguration("maven", pluginId);
            if (!configuration.isPresent()) continue;
            return configuration;
        }
        return Optional.empty();
    }

    private static enum Config implements Configs.Config
    {
        TYPE("type"),
        PORT("port"),
        PORT_NAME("port-name"),
        PATH("path"),
        SCHEME("scheme"),
        INITIAL_DELAY("initial-delay"),
        PERIOD("period"),
        TIMEOUT("timeout"),
        SUCCESS_THRESHOLD("success-threshold"),
        FAILURE_THRESHOLD("failure-threshold"),
        COMMAND("command"),
        HEADERS("headers");

        protected String key;

        private Config(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

