/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.vertx.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.javaexec.JavaExecGenerator;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.vertx.generator.VertxPortsExtractor;

public class VertxGenerator
extends JavaExecGenerator {
    public VertxGenerator(GeneratorContext context) {
        super(context, "vertx");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && (JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)"io.reactiverse", (String)"vertx-maven-plugin") || JKubeProjectUtil.hasDependency((JavaProject)this.getProject(), (String)"io.vertx", null));
    }

    protected List<String> getExtraJavaOptions() {
        List opts = super.getExtraJavaOptions();
        opts.add("-Dvertx.cacheDirBase=/tmp");
        if (!this.contains("-Dvertx.disableDnsResolver=", opts)) {
            opts.add("-Dvertx.disableDnsResolver=true");
        }
        if (JKubeProjectUtil.hasDependency((JavaProject)this.getProject(), (String)"io.vertx", (String)"vertx-dropwizard-metrics")) {
            opts.add("-Dvertx.metrics.options.enabled=true");
            opts.add("-Dvertx.metrics.options.jmxEnabled=true");
            opts.add("-Dvertx.metrics.options.jmxDomain=vertx");
        }
        if (!this.contains("-Djava.net.preferIPv4Stack", opts) && JKubeProjectUtil.hasDependency((JavaProject)this.getProject(), (String)"io.vertx", (String)"vertx-infinispan")) {
            opts.add("-Djava.net.preferIPv4Stack=true");
        }
        return opts;
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) {
        try {
            Map map = super.getEnv(prePackagePhase);
            String args = (String)map.get("JAVA_ARGS");
            if (args == null) {
                args = "";
            }
            if (JKubeProjectUtil.hasResource((JavaProject)this.getProject(), (String[])new String[]{"META-INF/services/io.vertx.core.spi.cluster.ClusterManager"})) {
                if (!args.isEmpty()) {
                    args = args + " ";
                }
                args = args + "-cluster";
            }
            if (!args.isEmpty()) {
                map.put("JAVA_ARGS", args);
            }
            return map;
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Error in finding resource", ioException);
        }
    }

    private boolean contains(String prefix, List<String> opts) {
        return opts.stream().anyMatch(val -> val.startsWith(prefix));
    }

    protected boolean isFatJar() {
        return !this.hasMainClass() && this.isUsingFatJarPlugin() || super.isFatJar();
    }

    private boolean isUsingFatJarPlugin() {
        JavaProject project = this.getProject();
        return JKubeProjectUtil.hasPlugin((JavaProject)project, (String)"org.apache.maven.plugins", (String)"maven-shade-plugin") || JKubeProjectUtil.hasPlugin((JavaProject)project, (String)"io.reactiverse", (String)"vertx-maven-plugin");
    }

    protected List<String> extractPorts() {
        Map extractedPorts = new VertxPortsExtractor(this.log).extract(this.getProject());
        ArrayList<String> ports = new ArrayList<String>();
        for (Integer p : extractedPorts.values()) {
            ports.add(String.valueOf(p));
        }
        return ports.isEmpty() ? super.extractPorts() : ports;
    }
}

