/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.watcher.api;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Collection;
import java.util.List;
import org.eclipse.jkube.kit.common.JKubeException;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.ClassUtil;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.common.util.PluginServiceFactory;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.watcher.api.Watcher;
import org.eclipse.jkube.watcher.api.WatcherContext;

public class WatcherManager {
    private static final String[] SERVICE_PATHS = new String[]{"META-INF/jkube/watcher-default", "META-INF/jkube/jkube-watcher-default", "META-INF/jkube/watcher", "META-INF/jkube-watcher"};

    private WatcherManager() {
    }

    public static void watch(List<ImageConfiguration> ret, String namespace, Collection<HasMetadata> resources, WatcherContext watcherCtx) throws Exception {
        boolean isOpenshift;
        if (watcherCtx.getJKubeBuildStrategy() != null && !watcherCtx.getJKubeBuildStrategy().isSupportsWatch()) {
            throw new JKubeException("Watch is not supported in " + watcherCtx.getJKubeBuildStrategy().getLabel() + " build strategy");
        }
        PluginServiceFactory pluginFactory = new PluginServiceFactory((Object)watcherCtx, new ClassLoader[0]);
        if (watcherCtx.isUseProjectClasspath()) {
            pluginFactory.addAdditionalClassLoader((ClassLoader)ClassUtil.createProjectClassLoader((List)watcherCtx.getBuildContext().getProject().getCompileClassPathElements(), (KitLogger)watcherCtx.getLogger()));
        }
        PlatformMode mode = (isOpenshift = OpenshiftHelper.isOpenShift((KubernetesClient)watcherCtx.getJKubeServiceHub().getClient())) ? PlatformMode.openshift : PlatformMode.kubernetes;
        KitLogger log = watcherCtx.getLogger();
        List watchers = pluginFactory.createServiceObjects(SERVICE_PATHS);
        List usableWatchers = watcherCtx.getConfig().prepareProcessors(watchers, "watcher");
        log.verbose("Watchers:", new Object[0]);
        Watcher chosen = null;
        for (Watcher watcher : usableWatchers) {
            if (watcher.isApplicable(ret, resources, mode)) {
                if (chosen == null) {
                    log.verbose(" - %s [selected]", new Object[]{watcher.getName()});
                    chosen = watcher;
                    continue;
                }
                log.verbose(" - %s", new Object[]{watcher.getName()});
                continue;
            }
            log.verbose(" - %s [not applicable]", new Object[]{watcher.getName()});
        }
        if (chosen == null) {
            throw new IllegalStateException("No watchers can be used for the current project");
        }
        log.info("Running watcher %s", new Object[]{chosen.getName()});
        chosen.watch(ret, namespace, resources, mode);
    }
}

