/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.watcher.standard;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.jkube.kit.build.api.helper.ImageNameFormatter;
import org.eclipse.jkube.kit.build.service.docker.DockerServiceHub;
import org.eclipse.jkube.kit.build.service.docker.WatchService;
import org.eclipse.jkube.kit.build.service.docker.watch.WatchContext;
import org.eclipse.jkube.kit.build.service.docker.watch.WatchException;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.watcher.api.BaseWatcher;
import org.eclipse.jkube.watcher.api.WatcherContext;
import org.eclipse.jkube.watcher.standard.PodExecutor;

public class DockerImageWatcher
extends BaseWatcher {
    private static final Duration WAIT_TIMEOUT = Duration.ofSeconds(60L);

    public DockerImageWatcher(WatcherContext watcherContext) {
        super(watcherContext, "docker-image");
    }

    public boolean isApplicable(List<ImageConfiguration> configs, Collection<HasMetadata> resources, PlatformMode mode) {
        return mode == PlatformMode.kubernetes;
    }

    public void watch(List<ImageConfiguration> configs, String namespace, Collection<HasMetadata> resources, PlatformMode mode) {
        WatchContext watchContext = this.getContext().getWatchContext();
        watchContext = watchContext.toBuilder().imageCustomizer(this::customizeImageName).containerRestarter(imageWatcher -> this.restartContainer((WatchService.ImageWatcher)imageWatcher, resources)).containerCommandExecutor(command -> this.executeCommandInPod(command, resources)).containerCopyTask(f -> this.copyFileToPod(f, resources)).build();
        DockerServiceHub hub = this.getContext().getJKubeServiceHub().getDockerServiceHub();
        try {
            hub.getWatchService().watch(watchContext, configs);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while watching", ex);
        }
    }

    protected void customizeImageName(ImageConfiguration imageConfig) {
        String imageName = imageConfig.getName();
        try {
            String imagePrefix = this.getImagePrefix(imageName);
            imageName = imagePrefix + "%t";
            ImageNameFormatter formatter = new ImageNameFormatter(this.getContext().getBuildContext().getProject(), new Date());
            imageName = formatter.format(imageName);
            imageConfig.setName(imageName);
            this.log.info("New image name: " + imageConfig.getName(), new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Caught: " + e, new Object[]{e});
        }
    }

    private String getImagePrefix(String imageName) {
        int idx = imageName.lastIndexOf(58);
        if (idx < 0) {
            throw new IllegalStateException("No ':' in the image name:  " + imageName);
        }
        String imagePrefix = imageName.substring(0, idx + 1);
        return imagePrefix;
    }

    protected void restartContainer(WatchService.ImageWatcher watcher, Collection<HasMetadata> resources) {
        ImageConfiguration imageConfig = watcher.getImageConfiguration();
        String imageName = imageConfig.getName();
        KubernetesClient client = this.getContext().getJKubeServiceHub().getClient();
        try {
            for (HasMetadata entity : resources) {
                this.updateImageName(client, entity, this.getImagePrefix(imageName), imageName);
            }
        }
        catch (KubernetesClientException e) {
            KubernetesHelper.handleKubernetesClientException((KubernetesClientException)e, (KitLogger)this.log);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private void updateImageName(KubernetesClient kubernetes, HasMetadata entity, String imagePrefix, String imageName) {
        DeploymentConfig resource;
        DeploymentConfigSpec spec;
        String name = KubernetesHelper.getName((HasMetadata)entity);
        String namespace = this.getContext().getNamespace();
        if (entity instanceof Deployment) {
            Deployment resource2 = (Deployment)entity;
            DeploymentSpec spec2 = resource2.getSpec();
            if (spec2 != null && this.updateImageName(entity, spec2.getTemplate(), imagePrefix, imageName)) {
                ((RollableScalableResource)((NonNamespaceOperation)kubernetes.apps().deployments().inNamespace(namespace)).resource((Object)resource2)).unlock().update();
                ((RollableScalableResource)((NonNamespaceOperation)kubernetes.apps().deployments().inNamespace(namespace)).withName(name)).rolling().restart();
            }
        } else if (entity instanceof ReplicaSet) {
            ReplicaSet resource3 = (ReplicaSet)entity;
            ReplicaSetSpec spec3 = resource3.getSpec();
            if (spec3 != null && this.updateImageName(entity, spec3.getTemplate(), imagePrefix, imageName)) {
                ((RollableScalableResource)((NonNamespaceOperation)kubernetes.apps().replicaSets().inNamespace(namespace)).resource((Object)resource3)).unlock().update();
                ((RollableScalableResource)((NonNamespaceOperation)kubernetes.apps().replicaSets().inNamespace(namespace)).withName(name)).rolling().restart();
            }
        } else if (entity instanceof ReplicationController) {
            ReplicationController resource4 = (ReplicationController)entity;
            ReplicationControllerSpec spec4 = resource4.getSpec();
            if (spec4 != null && this.updateImageName(entity, spec4.getTemplate(), imagePrefix, imageName)) {
                ((RollableScalableResource)((NonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).resource((Object)resource4)).unlock().update();
                ((RollableScalableResource)((NonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).withName(name)).rolling().restart();
            }
        } else if (entity instanceof DeploymentConfig && (spec = (resource = (DeploymentConfig)entity).getSpec()) != null && this.updateImageName(entity, spec.getTemplate(), imagePrefix, imageName)) {
            OpenShiftClient openshiftClient = OpenshiftHelper.asOpenShiftClient((KubernetesClient)kubernetes);
            if (openshiftClient == null) {
                this.log.warn("Ignoring DeploymentConfig %s as not connected to an OpenShift cluster", new Object[]{name});
            } else {
                ((DeployableScalableResource)((NonNamespaceOperation)openshiftClient.deploymentConfigs().inNamespace(namespace)).resource((Object)resource)).unlock().update();
            }
        }
    }

    private String executeCommandInPod(String command, Collection<HasMetadata> resources) throws IOException, WatchException {
        try {
            PodExecutor podExecutor = new PodExecutor(this.getContext(), WAIT_TIMEOUT);
            podExecutor.executeCommandInPod(resources, command);
            return podExecutor.getOutput();
        }
        catch (InterruptedException exception) {
            this.log.error("Execute command task interrupted", new Object[0]);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private void copyFileToPod(File fileToUpload, Collection<HasMetadata> resources) throws WatchException {
        PodExecutor podExecutor = new PodExecutor(this.getContext(), WAIT_TIMEOUT);
        podExecutor.uploadChangedFilesToPod(resources, fileToUpload);
    }

    private boolean updateImageName(HasMetadata entity, PodTemplateSpec template, String imagePrefix, String imageName) {
        List containers;
        boolean answer = false;
        PodSpec spec = template.getSpec();
        if (spec != null && (containers = spec.getContainers()) != null) {
            for (Container container : containers) {
                String image = container.getImage();
                if (image == null || !image.startsWith(imagePrefix)) continue;
                container.setImage(imageName);
                this.log.info("Updating " + KubernetesHelper.getKind((KubernetesResource)entity) + " " + KubernetesHelper.getName((HasMetadata)entity) + " to use image: " + imageName, new Object[0]);
                answer = true;
            }
        }
        return answer;
    }
}

