/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.watcher.standard;

import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ExecListenerLatch
implements ExecListener {
    private final CountDownLatch cdl = new CountDownLatch(1);
    private final AtomicInteger closeCode = new AtomicInteger(-1);
    private final AtomicReference<String> closeReason = new AtomicReference();
    private final AtomicReference<Status> exitStatus = new AtomicReference();

    public void onFailure(Throwable t, ExecListener.Response response) {
        this.cdl.countDown();
    }

    public void onClose(int code, String reason) {
        this.closeCode.set(code);
        this.closeReason.set(reason);
        this.cdl.countDown();
    }

    public void onExit(int code, Status status) {
        this.exitStatus.set(status);
    }

    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.cdl.await(timeout, timeUnit);
    }

    public int getCloseCode() {
        return this.closeCode.get();
    }

    public String getCloseReason() {
        return this.closeReason.get();
    }

    public Status getExitStatus() {
        return this.exitStatus.get();
    }
}

