/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.wildfly.jar.enricher;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.Plugin;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.specific.AbstractHealthCheckEnricher;
import org.eclipse.jkube.wildfly.jar.WildflyJarUtils;

public class WildflyJARHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public WildflyJARHealthCheckEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-healthcheck-wildfly-jar");
    }

    protected Probe getReadinessProbe() {
        return this.discoverWildflyJARHealthCheck(Config.READINESS_PATH, Config.READINESS_INITIAL_DELAY);
    }

    protected Probe getLivenessProbe() {
        return this.discoverWildflyJARHealthCheck(Config.LIVENESS_PATH, Config.LIVENESS_INITIAL_DELAY);
    }

    protected Probe getStartupProbe() {
        if (WildflyJarUtils.isStartupEndpointSupported(this.getContext().getProject())) {
            return this.discoverWildflyJARHealthCheck(Config.STARTUP_PATH, Config.STARTUP_INITIAL_DELAY);
        }
        return null;
    }

    private Probe discoverWildflyJARHealthCheck(Config path, Config initialDelay) {
        if (this.isAvailable()) {
            int port = Configs.asInt((String)this.getConfig(Config.PORT));
            if (port <= 0) {
                return null;
            }
            return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort((Object)port)).withPath(this.getConfig(path))).withScheme(this.getConfig(Config.SCHEME).toUpperCase())).endHttpGet()).withFailureThreshold(Integer.valueOf(Configs.asInt((String)this.getConfig(Config.FAILURE_THRESHOLD))))).withSuccessThreshold(Integer.valueOf(Configs.asInt((String)this.getConfig(Config.SUCCESS_THRESHOLD))))).withInitialDelaySeconds(Integer.valueOf(Configs.asInt((String)this.getConfig(initialDelay))))).withPeriodSeconds(Integer.valueOf(Configs.asInt((String)this.getConfig(Config.PERIOD_SECONDS))))).build();
        }
        return null;
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (PlatformMode.kubernetes.equals((Object)platformMode)) {
            final LinkedList containerBuilders = new LinkedList();
            builder.accept(new Visitor[]{new TypedVisitor<ContainerBuilder>(){

                public void visit(ContainerBuilder containerBuilder) {
                    containerBuilders.add(containerBuilder);
                }
            }});
            for (ContainerBuilder container : containerBuilders) {
                container.addToEnv(new EnvVar[]{((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.FieldRefNested)((EnvVarBuilder)new EnvVarBuilder().withName("HOSTNAME")).withNewValueFrom().withNewFieldRef().withFieldPath("metadata.name")).endFieldRef()).endValueFrom()).build()});
            }
        }
        super.create(platformMode, builder);
    }

    private boolean isAvailable() {
        if (Configs.asBoolean((String)this.getConfig(Config.ENFORCE_PROBES))) {
            return true;
        }
        JavaProject project = this.getContext().getProject();
        Plugin plugin = JKubeProjectUtil.getPlugin((JavaProject)project, (String)"org.wildfly.plugins", (String)"wildfly-jar-maven-plugin");
        if (plugin == null) {
            return false;
        }
        Map config = plugin.getConfiguration();
        return config.containsKey("cloud");
    }

    private static enum Config implements Configs.Config
    {
        SCHEME("scheme", "HTTP"),
        PORT("port", "9990"),
        FAILURE_THRESHOLD("failureThreshold", "3"),
        SUCCESS_THRESHOLD("successThreshold", "1"),
        LIVENESS_INITIAL_DELAY("livenessInitialDelay", "60"),
        READINESS_INITIAL_DELAY("readinessInitialDelay", "10"),
        STARTUP_INITIAL_DELAY("startupInitialDelay", "10"),
        READINESS_PATH("readinessPath", "/health/ready"),
        LIVENESS_PATH("livenessPath", "/health/live"),
        STARTUP_PATH("startupPath", "/health/started"),
        PERIOD_SECONDS("periodSeconds", "10"),
        ENFORCE_PROBES("enforceProbes", "false");

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

