/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.wildfly.jar.enricher;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.Plugin;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.specific.AbstractHealthCheckEnricher;

public class WildflyJARHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public static final String BOOTABLE_JAR_GROUP_ID = "org.wildfly.plugins";
    public static final String BOOTABLE_JAR_ARTIFACT_ID = "wildfly-jar-maven-plugin";

    public WildflyJARHealthCheckEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-healthcheck-wildfly-jar");
    }

    protected Probe getReadinessProbe() {
        return this.discoverWildflyJARHealthCheck(true);
    }

    protected Probe getLivenessProbe() {
        return this.discoverWildflyJARHealthCheck(false);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (PlatformMode.kubernetes.equals((Object)platformMode)) {
            final LinkedList containerBuilders = new LinkedList();
            builder.accept(new Visitor[]{new TypedVisitor<ContainerBuilder>(){

                public void visit(ContainerBuilder containerBuilder) {
                    containerBuilders.add(containerBuilder);
                }
            }});
            for (ContainerBuilder container : containerBuilders) {
                container.addToEnv(new EnvVar[]{((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.FieldRefNested)((EnvVarBuilder)new EnvVarBuilder().withName("HOSTNAME")).withNewValueFrom().withNewFieldRef().withFieldPath("metadata.name")).endFieldRef()).endValueFrom()).build()});
            }
        }
        super.create(platformMode, builder);
    }

    private Probe discoverWildflyJARHealthCheck(boolean isReadiness) {
        if (this.isAvailable()) {
            Integer port = this.getPort();
            if (port <= 0) {
                return null;
            }
            int initialDelay = isReadiness ? this.getReadinessInitialDelay() : this.getLivenessInitialDelay();
            String scheme = this.getScheme().toUpperCase();
            String path = isReadiness ? this.getReadinessPath() : this.getLivenessPath();
            return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(port)).withPath(path)).withScheme(scheme)).endHttpGet()).withFailureThreshold(Integer.valueOf(this.getFailureThreshold()))).withSuccessThreshold(Integer.valueOf(this.getSuccessThreshold()))).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
        }
        return null;
    }

    private boolean isAvailable() {
        if (this.isProbeEnforced()) {
            return true;
        }
        JavaProject project = ((JKubeEnricherContext)this.getContext()).getProject();
        Plugin plugin = JKubeProjectUtil.getPlugin((JavaProject)project, (String)BOOTABLE_JAR_GROUP_ID, (String)BOOTABLE_JAR_ARTIFACT_ID);
        if (plugin == null) {
            return false;
        }
        Map config = plugin.getConfiguration();
        return config.containsKey("cloud");
    }

    protected int getFailureThreshold() {
        return Configs.asInteger((String)this.getConfig(Config.FAILURETHRESHOLD));
    }

    protected boolean isProbeEnforced() {
        return Configs.asBoolean((String)this.getConfig(Config.ENFORCEPROBES));
    }

    protected int getSuccessThreshold() {
        return Configs.asInteger((String)this.getConfig(Config.SUCCESSTHRESHOLD));
    }

    protected String getScheme() {
        return Configs.asString((String)this.getConfig(Config.SCHEME));
    }

    protected int getPort() {
        return Configs.asInt((String)this.getConfig(Config.PORT));
    }

    protected String getLivenessPath() {
        return Configs.asString((String)this.getConfig(Config.LIVENESSPATH));
    }

    protected int getLivenessInitialDelay() {
        return Configs.asInt((String)this.getConfig(Config.LIVENESSINITIALDELAY));
    }

    protected String getReadinessPath() {
        return Configs.asString((String)this.getConfig(Config.READINESSPATH));
    }

    protected int getReadinessInitialDelay() {
        return Configs.asInt((String)this.getConfig(Config.READINESSINITIALDELAY));
    }

    private static enum Config implements Configs.Config
    {
        SCHEME("scheme", "HTTP"),
        PORT("port", "9990"),
        FAILURETHRESHOLD("failureThreshold", "3"),
        SUCCESSTHRESHOLD("successThreshold", "1"),
        LIVENESSINITIALDELAY("livenessInitialDelay", "60"),
        READINESSINITIALDELAY("readinessInitialDelay", "10"),
        READINESSPATH("readinessPath", "/health/ready"),
        LIVENESSPATH("livenessPath", "/health/live"),
        ENFORCEPROBES("enforceProbes", "false");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

