/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.AnsiLogger;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.MavenUtil;
import org.eclipse.jkube.kit.config.access.ClusterAccess;
import org.eclipse.jkube.kit.config.access.ClusterConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeConfiguration;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.maven.plugin.mojo.KitLoggerProvider;

public abstract class AbstractJKubeMojo
extends AbstractMojo
implements KitLoggerProvider {
    protected static final String DEFAULT_LOG_PREFIX = "k8s: ";
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(property="jkube.useColor", defaultValue="true")
    protected boolean useColor;
    @Parameter(property="jkube.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="jkube.verbose", defaultValue="false")
    protected String verbose;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter
    protected ClusterConfiguration access;
    protected KitLogger log;
    protected ClusterAccess clusterAccess;
    protected JKubeServiceHub jkubeServiceHub;

    protected void init() throws DependencyResolutionRequiredException {
        this.log = this.createLogger(null);
        this.clusterAccess = new ClusterAccess(this.log, this.initClusterConfiguration());
        JavaProject javaProject = MavenUtil.convertMavenProjectToJKubeProject((MavenProject)this.project, (MavenSession)this.session);
        this.jkubeServiceHub = JKubeServiceHub.builder().log(this.log).configuration(JKubeConfiguration.builder().project(javaProject).reactorProjects(Collections.singletonList(javaProject)).build()).clusterAccess(this.clusterAccess).platformMode(this.getRuntimeMode()).build();
    }

    protected boolean canExecute() {
        return !this.skip;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.init();
            if (this.canExecute()) {
                this.executeInternal();
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    public abstract void executeInternal() throws MojoExecutionException, MojoFailureException;

    @Override
    public KitLogger getKitLogger() {
        return this.log;
    }

    protected String getProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            value = this.project.getProperties().getProperty(key);
        }
        return value;
    }

    protected RuntimeMode getRuntimeMode() {
        return RuntimeMode.KUBERNETES;
    }

    protected String getLogPrefix() {
        return DEFAULT_LOG_PREFIX;
    }

    protected KitLogger createLogger(String prefix) {
        return new AnsiLogger(this.getLog(), this.useColorForLogging(), this.verbose, this.settings.getInteractiveMode() == false, this.getLogPrefix() + Optional.ofNullable(prefix).map(" "::concat).orElse(""));
    }

    private boolean useColorForLogging() {
        return this.useColor && MessageUtils.isColorEnabled() && (!EnvUtil.isWindows() || MavenUtil.isMaven350OrLater((MavenSession)this.session));
    }

    protected ClusterConfiguration initClusterConfiguration() {
        return ClusterConfiguration.from((ClusterConfiguration)this.access, (Properties[])new Properties[]{System.getProperties(), this.project.getProperties()}).build();
    }
}

