/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.io.File;
import java.net.URL;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.MavenUtil;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.config.access.ClusterAccess;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.service.ApplyService;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.maven.plugin.mojo.ManifestProvider;
import org.eclipse.jkube.maven.plugin.mojo.build.AbstractJKubeMojo;

@Mojo(name="apply", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.INSTALL)
public class ApplyMojo
extends AbstractJKubeMojo
implements ManifestProvider {
    public static final String DEFAULT_KUBERNETES_MANIFEST = "${basedir}/target/classes/META-INF/jkube/kubernetes.yml";
    public static final String DEFAULT_OPENSHIFT_MANIFEST = "${basedir}/target/classes/META-INF/jkube/openshift.yml";
    @Parameter(property="jkube.recreate", defaultValue="false")
    protected boolean recreate;
    @Parameter(property="jkube.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/kubernetes.yml")
    protected File kubernetesManifest;
    @Parameter(property="jkube.deploy.create", defaultValue="true")
    private boolean createNewResources;
    @Parameter(property="jkube.rolling", defaultValue="false")
    private boolean rollingUpgrades;
    @Parameter(property="jkube.deploy.failOnNoKubernetesJson", defaultValue="false")
    private boolean failOnNoKubernetesJson;
    @Parameter(property="jkube.deploy.servicesOnly", defaultValue="false")
    private boolean servicesOnly;
    @Parameter(property="jkube.deploy.ignoreServices", defaultValue="false")
    private boolean ignoreServices;
    @Parameter(property="jkube.deploy.processTemplatesLocally", defaultValue="false")
    private boolean processTemplatesLocally;
    @Parameter(property="jkube.deploy.deletePods", defaultValue="true")
    private boolean deletePodsOnReplicationControllerUpdate;
    @Parameter(property="jkube.deploy.ignoreRunningOAuthClients", defaultValue="true")
    private boolean ignoreRunningOAuthClients;
    @Parameter(property="jkube.deploy.jsonLogDir", defaultValue="${basedir}/target/jkube/applyJson")
    private File jsonLogDir;
    @Parameter(property="jkube.serviceUrl.waitSeconds", defaultValue="5")
    protected long serviceUrlWaitTimeSeconds;
    @Parameter
    protected ResourceConfig resources;
    @Parameter(property="jkube.resourceDir", defaultValue="${basedir}/src/main/jkube")
    private File resourceDir;
    @Parameter(property="jkube.environment")
    private String environment;
    @Parameter(property="jkube.skip.apply", defaultValue="false")
    protected boolean skipApply;
    protected ApplyService applyService;

    @Override
    protected boolean canExecute() {
        return super.canExecute() && !this.skipApply;
    }

    @Override
    public File getKubernetesManifest() {
        return this.kubernetesManifest;
    }

    @Override
    public void executeInternal() throws MojoExecutionException {
        try (KubernetesClient kubernetes = this.jkubeServiceHub.getClient();){
            this.applyService = this.jkubeServiceHub.getApplyService();
            this.initServices(kubernetes);
            URL masterUrl = kubernetes.getMasterUrl();
            File manifest = this.getManifest(kubernetes);
            if (!manifest.exists() || !manifest.isFile()) {
                if (this.failOnNoKubernetesJson) {
                    throw new MojoFailureException("No such generated manifest file: " + manifest);
                }
                this.log.warn("No such generated manifest file %s for this project so ignoring", new Object[]{manifest});
                return;
            }
            String clusterKind = "Kubernetes";
            if (OpenshiftHelper.isOpenShift((KubernetesClient)kubernetes)) {
                clusterKind = "OpenShift";
            }
            KubernetesResourceUtil.validateKubernetesMasterUrl((URL)masterUrl);
            Set entities = KubernetesResourceUtil.loadResources((File)manifest);
            this.log.info("Using %s at %s in namespace %s with manifest %s ", new Object[]{clusterKind, masterUrl, this.clusterAccess.getNamespace(), manifest});
            this.configureApplyService(kubernetes, entities);
            this.applyEntities(kubernetes, ApplyService.getNamespaceForApplyService((Set)entities, (ClusterAccess)this.clusterAccess), manifest.getName(), entities);
            this.log.info("[[B]]HINT:[[B]] Use the command `%s get pods -w` to watch your pods start up", new Object[]{this.clusterAccess.isOpenShift() ? "oc" : "kubectl"});
        }
        catch (KubernetesClientException e) {
            KubernetesResourceUtil.handleKubernetesClientException((KubernetesClientException)e, (KitLogger)this.log);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void applyEntities(KubernetesClient kubernetes, String namespace, String fileName, Set<HasMetadata> entities) throws Exception {
        KitLogger serviceLogger = this.createLogger("[[G]][SVC][[G]] [[s]]");
        this.applyService.applyEntities(fileName, entities, serviceLogger, this.serviceUrlWaitTimeSeconds, this.resources, this.resourceDir, this.environment);
    }

    protected void initServices(KubernetesClient kubernetes) {
        this.log.debug("No services required in ApplyMojo", new Object[0]);
    }

    public boolean isRollingUpgradePreserveScale() {
        return false;
    }

    public MavenProject getProject() {
        return this.project;
    }

    protected void disableOpenShiftFeatures(ApplyService applyService) {
        this.processTemplatesLocally = true;
        applyService.setSupportOAuthClients(false);
        applyService.setProcessTemplatesLocally(true);
    }

    private void configureApplyService(KubernetesClient kubernetes, Set<HasMetadata> entities) {
        this.applyService.setAllowCreate(this.createNewResources);
        this.applyService.setServicesOnlyMode(this.servicesOnly);
        this.applyService.setIgnoreServiceMode(this.ignoreServices);
        this.applyService.setLogJsonDir(this.jsonLogDir);
        this.applyService.setBasedir(MavenUtil.getRootProjectFolder((MavenProject)this.getProject()));
        this.applyService.setIgnoreRunningOAuthClients(this.ignoreRunningOAuthClients);
        this.applyService.setProcessTemplatesLocally(this.processTemplatesLocally);
        this.applyService.setDeletePodsOnReplicationControllerUpdate(this.deletePodsOnReplicationControllerUpdate);
        this.applyService.setRollingUpgrade(this.rollingUpgrades);
        this.applyService.setRollingUpgradePreserveScale(this.isRollingUpgradePreserveScale());
        this.applyService.setRecreateMode(this.recreate);
        this.applyService.setNamespace(ApplyService.getNamespaceForApplyService(entities, (ClusterAccess)this.clusterAccess));
        boolean openShift = OpenshiftHelper.isOpenShift((KubernetesClient)kubernetes);
        if (openShift) {
            this.log.info("[[B]]OpenShift[[B]] platform detected", new Object[0]);
        } else {
            this.disableOpenShiftFeatures(this.applyService);
        }
    }
}

