/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.RegistryConfig;
import org.eclipse.jkube.kit.common.util.AnsiLogger;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.MavenUtil;
import org.eclipse.jkube.kit.config.access.ClusterAccess;
import org.eclipse.jkube.kit.config.access.ClusterConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesClientUtil;
import org.eclipse.jkube.maven.plugin.mojo.KitLoggerProvider;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class AbstractJKubeMojo
extends AbstractMojo
implements KitLoggerProvider {
    protected static final String DEFAULT_LOG_PREFIX = "k8s: ";
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter
    protected ResourceConfig resources;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    protected MojoExecution mojoExecution;
    @Parameter(property="jkube.build.strategy")
    protected JKubeBuildStrategy buildStrategy;
    @Parameter(property="jkube.useColor", defaultValue="true")
    protected boolean useColor;
    @Parameter(property="jkube.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="jkube.verbose", defaultValue="false")
    protected String verbose;
    @Parameter(property="jkube.offline", defaultValue="false")
    protected boolean offline;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(property="jkube.namespace")
    public String namespace;
    @Parameter
    protected ClusterConfiguration access;
    @Component(role=SecDispatcher.class, hint="default")
    protected SecDispatcher securityDispatcher;
    protected KitLogger log;
    protected ClusterAccess clusterAccess;
    protected JKubeServiceHub jkubeServiceHub;
    protected JavaProject javaProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.init();
            if (this.shouldSkip()) {
                this.log.info("`%s` goal is skipped.", new Object[]{this.mojoExecution.getMojoDescriptor().getFullGoalName()});
                return;
            }
            this.executeInternal();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    protected void init() throws DependencyResolutionRequiredException {
        this.log = this.createLogger(null);
        this.clusterAccess = new ClusterAccess(this.log, this.initClusterConfiguration());
        this.javaProject = MavenUtil.convertMavenProjectToJKubeProject((MavenProject)this.project, (MavenSession)this.session);
        this.jkubeServiceHub = this.initJKubeServiceHubBuilder(this.javaProject).build();
        this.resources = KubernetesClientUtil.updateResourceConfigNamespace((String)this.namespace, (ResourceConfig)this.resources);
    }

    protected boolean shouldSkip() {
        return this.skip;
    }

    public abstract void executeInternal() throws MojoExecutionException, MojoFailureException;

    @Override
    public KitLogger getKitLogger() {
        return this.log;
    }

    protected RuntimeMode getRuntimeMode() {
        return RuntimeMode.KUBERNETES;
    }

    protected String getLogPrefix() {
        return DEFAULT_LOG_PREFIX;
    }

    protected KitLogger createLogger(String prefix) {
        return new AnsiLogger(this.getLog(), this.useColorForLogging(), this.verbose, this.settings.getInteractiveMode() == false, this.getLogPrefix() + Optional.ofNullable(prefix).map(" "::concat).orElse(""));
    }

    protected Settings getSettings() {
        return this.settings;
    }

    private boolean useColorForLogging() {
        return this.useColor && MessageUtils.isColorEnabled() && (!EnvUtil.isWindows() || MavenUtil.isMaven350OrLater((MavenSession)this.session));
    }

    protected ClusterConfiguration initClusterConfiguration() {
        return ClusterConfiguration.from((ClusterConfiguration)this.access, (Properties[])new Properties[]{System.getProperties(), this.project.getProperties()}).build();
    }

    protected JKubeServiceHub.JKubeServiceHubBuilder initJKubeServiceHubBuilder(JavaProject javaProject) {
        return JKubeServiceHub.builder().log(this.log).configuration(JKubeConfiguration.builder().project(javaProject).reactorProjects(Collections.singletonList(javaProject)).registryConfig(RegistryConfig.builder().settings(MavenUtil.getRegistryServerFromMavenSettings((Settings)this.settings)).passwordDecryptionMethod(this::decrypt).build()).build()).clusterAccess(this.clusterAccess).offline(this.offline).platformMode(this.getRuntimeMode());
    }

    public ResourceConfig getResources() {
        return this.resources;
    }

    String decrypt(String password) {
        try {
            return this.securityDispatcher.decrypt(password);
        }
        catch (SecDispatcherException e) {
            this.getKitLogger().error("Failure in decrypting password", new Object[0]);
            return password;
        }
    }
}

