/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.resource.helm.HelmConfig;
import org.eclipse.jkube.kit.resource.helm.HelmServiceUtil;
import org.eclipse.jkube.maven.plugin.mojo.build.HelmMojo;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;

@Mojo(name="helm-push", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.COMPILE)
public class HelmPushMojo
extends HelmMojo {
    @Override
    public void executeInternal() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        try {
            super.executeInternal();
            this.helm = HelmServiceUtil.initHelmPushConfig((HelmConfig)this.helm, (JavaProject)this.javaProject);
            if (this.securityDispatcher instanceof DefaultSecDispatcher) {
                ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile(this.helm.getSecurity());
            }
            this.jkubeServiceHub.getHelmService().uploadHelmChart(this.helm);
        }
        catch (Exception exp) {
            this.getKitLogger().error("Error performing helm push", new Object[]{exp});
            throw new MojoExecutionException(exp.getMessage(), exp);
        }
    }
}

