/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.develop;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.GeneratorMode;
import org.eclipse.jkube.kit.build.service.docker.DockerServiceHub;
import org.eclipse.jkube.kit.build.service.docker.watch.WatchContext;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.AnsiLogger;
import org.eclipse.jkube.kit.common.util.BuildReferenceDateUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.MavenUtil;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.config.access.ClusterAccess;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesClientUtil;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.profile.ProfileUtil;
import org.eclipse.jkube.maven.plugin.mojo.ManifestProvider;
import org.eclipse.jkube.maven.plugin.mojo.build.AbstractDockerMojo;
import org.eclipse.jkube.watcher.api.WatcherContext;
import org.eclipse.jkube.watcher.api.WatcherManager;

@Mojo(name="watch", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(goal="deploy")
public class WatchMojo
extends AbstractDockerMojo
implements ManifestProvider {
    @Parameter(property="jkube.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/kubernetes.yml")
    protected File kubernetesManifest;
    @Parameter
    private ProcessorConfig watcher;
    @Component
    private BuildPluginManager pluginManager;

    @Override
    public File getKubernetesManifest() {
        return this.kubernetesManifest;
    }

    @Override
    public void executeInternal() throws MojoExecutionException {
        try (KubernetesClient kubernetesClient = this.jkubeServiceHub.getClient();){
            URL masterUrl = kubernetesClient.getMasterUrl();
            KubernetesResourceUtil.validateKubernetesMasterUrl((URL)masterUrl);
            List appliedK8sResources = KubernetesHelper.loadResources((File)this.getManifest(kubernetesClient));
            WatcherContext context = this.getWatcherContext();
            WatcherManager.watch(this.getResolvedImages(), (String)KubernetesClientUtil.applicableNamespace(null, (String)this.namespace, (ResourceConfig)this.resources, (ClusterAccess)this.clusterAccess), (Collection)appliedK8sResources, (WatcherContext)context);
        }
        catch (KubernetesClientException ex) {
            KubernetesResourceUtil.handleKubernetesClientException((KubernetesClientException)ex, (KitLogger)this.log);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("An error has occurred while while trying to watch the resources", ex);
        }
    }

    private WatcherContext getWatcherContext() throws MojoExecutionException {
        try {
            JKubeConfiguration buildContext = this.initJKubeConfiguration();
            WatchContext watchContext = this.jkubeServiceHub.getDockerServiceHub() != null ? this.getWatchContext() : null;
            return WatcherContext.builder().buildContext(buildContext).watchContext(watchContext).config(ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.WATCHER_CONFIG, (String)this.profile, (List)ResourceUtil.getFinalResourceDirs((File)this.resourceDir, (String)this.environment), (ProcessorConfig)this.watcher)).logger(this.log).newPodLogger(this.createLogger("[[C]][NEW][[C]] ")).oldPodLogger(this.createLogger("[[R]][OLD][[R]] ")).useProjectClasspath(this.useProjectClasspath).jKubeServiceHub(this.jkubeServiceHub).jKubeBuildStrategy(this.getJKubeBuildStrategy()).build();
        }
        catch (DependencyResolutionRequiredException dependencyException) {
            throw new MojoExecutionException("Instructed to use project classpath, but cannot. Continuing build if we can: " + dependencyException.getMessage());
        }
        catch (IOException ioException) {
            throw new MojoExecutionException(ioException.getMessage());
        }
    }

    @Override
    protected GeneratorContext.GeneratorContextBuilder generatorContextBuilder() {
        return GeneratorContext.builder().config(ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (List)ResourceUtil.getFinalResourceDirs((File)this.resourceDir, (String)this.environment), (ProcessorConfig)this.generator)).project(this.javaProject).logger(this.log).runtimeMode(this.getConfiguredRuntimeMode()).useProjectClasspath(this.useProjectClasspath).generatorMode(GeneratorMode.WATCH);
    }

    protected KitLogger createLogger(String prefix) {
        return new AnsiLogger(this.getLog(), this.useColor, this.verbose, this.settings.getInteractiveMode() == false, this.getLogPrefix() + prefix);
    }

    protected WatchContext getWatchContext() throws DependencyResolutionRequiredException, IOException {
        DockerServiceHub hub = this.jkubeServiceHub.getDockerServiceHub();
        return WatchContext.builder().watchInterval(this.watchInterval).watchMode(this.watchMode).watchPostExec(this.watchPostExec).buildTimestamp(BuildReferenceDateUtil.getBuildTimestamp((Map)this.getPluginContext(), (String)"CONTEXT_KEY_BUILD_TIMESTAMP", (String)this.project.getBuild().getDirectory(), (String)"docker/build.timestamp")).gavLabel(this.getGavLabel()).buildContext(this.initJKubeConfiguration()).hub(hub).postGoalTask(() -> MavenUtil.callMavenPluginWithGoal((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager, (String)this.watchPostGoal, (KitLogger)this.log)).build();
    }
}

