/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.jkube.kit.resource.helm.GeneratedChartListener;
import org.eclipse.jkube.maven.plugin.mojo.build.AbstractHelmMojo;

@Mojo(name="helm", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class HelmMojo
extends AbstractHelmMojo {
    @Parameter(property="jkube.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/kubernetes.yml")
    private File kubernetesManifest;
    @Component
    MavenProjectHelper projectHelper;

    @Override
    public void init() throws MojoFailureException {
        super.init();
        File manifest = this.getKubernetesManifest();
        if (manifest == null || !manifest.isFile()) {
            this.logManifestNotFoundWarning(manifest);
        }
        GeneratedChartListener generatedChartListener = (helmConfig, type, chartFile) -> this.projectHelper.attachArtifact(this.project, helmConfig.getChartExtension(), type.getClassifier(), chartFile);
        this.getHelm().getGeneratedChartListeners().add(generatedChartListener);
    }

    @Override
    public void executeInternal() throws MojoExecutionException {
        try {
            this.jkubeServiceHub.getHelmService().generateHelmCharts(this.getHelm());
        }
        catch (IOException exception) {
            throw new MojoExecutionException(exception.getMessage());
        }
    }

    protected void logManifestNotFoundWarning(File manifest) {
        this.getKitLogger().warn("No Kubernetes manifest file has been generated yet by the k8s:resource goal at: " + manifest, new Object[0]);
    }

    protected File getKubernetesManifest() {
        return this.kubernetesManifest;
    }
}

