/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.develop;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesClientUtil;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.maven.plugin.mojo.OpenShift;
import org.eclipse.jkube.maven.plugin.mojo.develop.UndeployMojo;

@Mojo(name="undeploy", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.INSTALL)
public class OpenshiftUndeployMojo
extends UndeployMojo {
    @Parameter(property="jkube.s2i.buildNameSuffix", defaultValue="-s2i")
    protected String s2iBuildNameSuffix;
    @Parameter(property="jkube.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/openshift.yml")
    private File openshiftManifest;
    @Parameter(property="jkube.openshiftImageStreamManifest", defaultValue="${basedir}/target/${project.artifactId}-is.yml")
    private File openshiftImageStreamManifest;

    protected void applyEntities(KubernetesClient kubernetes, String namespace, String fileName, Set<HasMetadata> entities) throws Exception {
        super.applyEntities(kubernetes, namespace, fileName, entities);
        Set openShiftEntities = Stream.concat(entities.stream(), this.getImageStreamManifest().stream()).collect(Collectors.toSet());
        KubernetesClientUtil.deleteOpenShiftEntities((KubernetesClient)kubernetes, (String)namespace, openShiftEntities, (String)this.s2iBuildNameSuffix, (KitLogger)this.log);
    }

    public File getManifest(KubernetesClient kubernetesClient) {
        return OpenShift.getOpenShiftManifest(kubernetesClient, this.getKubernetesManifest(), this.openshiftManifest);
    }

    protected String getLogPrefix() {
        return "oc: ";
    }

    private Set<HasMetadata> getImageStreamManifest() {
        return Optional.ofNullable(this.openshiftImageStreamManifest).filter(File::exists).filter(File::isFile).map(manifest -> {
            try {
                return KubernetesResourceUtil.loadResources((File)manifest);
            }
            catch (IOException e) {
                this.log.warn("Unable to load ImageStream manifest '%s'", new Object[]{manifest});
                return null;
            }
        }).orElse(Collections.emptySet());
    }
}

