/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.maven.plugin.mojo.build.BuildMojo;

@Mojo(name="build", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.COMPILE)
public class OpenshiftBuildMojo
extends BuildMojo {
    @Parameter(property="jkube.build.pullSecret", defaultValue="pullsecret-jkube")
    protected String openshiftPullSecret;
    @Parameter(property="jkube.s2i.buildNameSuffix", defaultValue="-s2i")
    protected String s2iBuildNameSuffix;
    @Parameter(property="jkube.s2i.imageStreamLookupPolicyLocal", defaultValue="true")
    protected boolean s2iImageStreamLookupPolicyLocal = true;

    protected boolean isDockerAccessRequired() {
        return this.runtimeMode == RuntimeMode.KUBERNETES;
    }

    public RuntimeMode getConfiguredRuntimeMode() {
        return RuntimeMode.OPENSHIFT;
    }

    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
        if (this.runtimeMode == RuntimeMode.OPENSHIFT) {
            this.log.info("Using [[B]]OpenShift[[B]] build with strategy [[B]]%s[[B]]", new Object[]{this.getJKubeBuildStrategy().getLabel()});
        }
        return super.customizeConfig(configs);
    }

    protected BuildServiceConfig.BuildServiceConfigBuilder buildServiceConfigBuilder() {
        return super.buildServiceConfigBuilder().openshiftPullSecret(this.openshiftPullSecret).s2iBuildNameSuffix(this.s2iBuildNameSuffix).s2iImageStreamLookupPolicyLocal(this.s2iImageStreamLookupPolicyLocal);
    }

    protected GeneratorContext.GeneratorContextBuilder generatorContextBuilder() throws DependencyResolutionRequiredException {
        return super.generatorContextBuilder().strategy(this.getJKubeBuildStrategy());
    }

    protected String getLogPrefix() {
        return "oc: ";
    }

    protected JKubeBuildStrategy getJKubeBuildStrategy() {
        if (this.buildStrategy != null) {
            return this.buildStrategy;
        }
        return JKubeBuildStrategy.s2i;
    }
}

