/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.common.BuildRecreateMode;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.maven.plugin.mojo.build.BuildMojo;

@Mojo(name="build", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.COMPILE)
public class OpenshiftBuildMojo
extends BuildMojo {
    @Parameter(property="jkube.build.pullSecret", defaultValue="pullsecret-jkube")
    protected String openshiftPullSecret;
    @Parameter(property="jkube.s2i.buildNameSuffix", defaultValue="-s2i")
    protected String s2iBuildNameSuffix;
    @Parameter(property="jkube.s2i.imageStreamLookupPolicyLocal", defaultValue="true")
    protected boolean s2iImageStreamLookupPolicyLocal = true;
    @Parameter(property="jkube.build.buildOutput.kind", defaultValue="ImageStreamTag")
    protected String buildOutputKind;
    @Parameter(property="jkube.build.pushSecret")
    protected String openshiftPushSecret;

    protected boolean isDockerAccessRequired() {
        return this.runtimeMode == RuntimeMode.KUBERNETES;
    }

    public RuntimeMode getConfiguredRuntimeMode() {
        return RuntimeMode.OPENSHIFT;
    }

    protected void doExecute() throws MojoExecutionException {
        if (this.runtimeMode == RuntimeMode.OPENSHIFT) {
            this.log.info("Using [[B]]OpenShift[[B]] build with strategy [[B]]%s[[B]]", new Object[]{this.getJKubeBuildStrategy().getLabel()});
        }
        super.doExecute();
    }

    protected GeneratorContext.GeneratorContextBuilder generatorContextBuilder() {
        return super.generatorContextBuilder().strategy(this.getJKubeBuildStrategy()).openshiftForcePull(this.forcePull).openshiftS2iBuildNameSuffix(this.s2iBuildNameSuffix).openshiftS2iImageStreamLookupPolicyLocal(this.s2iImageStreamLookupPolicyLocal).openshiftPullSecret(this.openshiftPullSecret).openshiftPushSecret(this.openshiftPushSecret).openshiftBuildOutputKind(this.buildOutputKind).openshiftBuildRecreate(BuildRecreateMode.fromParameter((String)this.buildRecreate));
    }

    protected String getLogPrefix() {
        return "oc: ";
    }

    protected JKubeBuildStrategy getJKubeBuildStrategy() {
        if (this.buildStrategy != null) {
            return this.buildStrategy;
        }
        return JKubeBuildStrategy.s2i;
    }
}

