/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.develop;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jkube.kit.config.service.PodLogService;
import org.eclipse.jkube.maven.plugin.mojo.OpenShift;
import org.eclipse.jkube.maven.plugin.mojo.develop.LogMojo;

@Mojo(name="log", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.VALIDATE)
public class OpenshiftLogMojo
extends LogMojo {
    @Parameter(property="jkube.s2i.buildNameSuffix", defaultValue="-s2i")
    protected String s2iBuildNameSuffix;
    @Parameter(property="jkube.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/openshift.yml")
    private File openshiftManifest;

    public File getManifest(KubernetesClient kubernetesClient) {
        return OpenShift.getOpenShiftManifest(kubernetesClient, this.getKubernetesManifest(), this.openshiftManifest);
    }

    protected PodLogService.PodLogServiceContext.PodLogServiceContextBuilder podLogServiceContextBuilder() {
        return super.podLogServiceContextBuilder().s2iBuildNameSuffix(this.s2iBuildNameSuffix);
    }

    protected String getLogPrefix() {
        return "oc: ";
    }
}

