/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.develop;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.maven.plugin.mojo.OpenShift;
import org.eclipse.jkube.maven.plugin.mojo.develop.WatchMojo;

@Mojo(name="watch", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(goal="deploy")
public class OpenshiftWatchMojo
extends WatchMojo {
    @Parameter(property="jkube.build.strategy")
    protected JKubeBuildStrategy buildStrategy = JKubeBuildStrategy.s2i;
    @Parameter(property="jkube.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/openshift.yml")
    private File openshiftManifest;

    public RuntimeMode getConfiguredRuntimeMode() {
        return RuntimeMode.OPENSHIFT;
    }

    public File getManifest(KubernetesClient kubernetesClient) {
        return OpenShift.getOpenShiftManifest(kubernetesClient, this.getKubernetesManifest(), this.openshiftManifest);
    }

    protected GeneratorContext.GeneratorContextBuilder generatorContextBuilder() {
        return super.generatorContextBuilder().strategy(this.buildStrategy);
    }

    protected String getLogPrefix() {
        return "oc: ";
    }

    protected boolean isDockerAccessRequired() {
        return false;
    }
}

