/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.cassandra.column;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import jakarta.nosql.column.ColumnManagerFactory;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.jnosql.communication.cassandra.column.CassandraColumnManager;
import org.eclipse.jnosql.communication.cassandra.column.DefaultCassandraColumnManager;

public class CassandraColumnManagerFactory
implements ColumnManagerFactory {
    private final CqlSessionBuilder sessionBuilder;
    private final Executor executor;

    CassandraColumnManagerFactory(CqlSessionBuilder sessionBuilder, List<String> queries, Executor executor) {
        this.sessionBuilder = sessionBuilder;
        this.executor = executor;
        this.load(queries);
    }

    void load(List<String> queries) {
        CqlSession session = (CqlSession)this.sessionBuilder.build();
        queries.forEach(arg_0 -> ((CqlSession)session).execute(arg_0));
        session.close();
    }

    public CassandraColumnManager apply(String database) {
        return new DefaultCassandraColumnManager((CqlSession)this.sessionBuilder.build(), this.executor, database);
    }

    public void close() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CassandraColumnManagerFactory{");
        sb.append("cluster=").append(this.sessionBuilder);
        sb.append(", executor=").append(this.executor);
        sb.append('}');
        return sb.toString();
    }
}

