/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.cassandra.column;

import jakarta.nosql.Settings;
import jakarta.nosql.column.ColumnConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.eclipse.jnosql.communication.cassandra.column.CassandraColumnManagerFactory;
import org.eclipse.jnosql.communication.cassandra.column.CassandraProperties;

public final class CassandraConfiguration
implements ColumnConfiguration {
    private CassandraColumnManagerFactory getManagerFactory(Map<String, String> configurations) {
        Objects.requireNonNull(configurations);
        CassandraProperties properties = CassandraProperties.of(configurations);
        ExecutorService executorService = properties.createExecutorService();
        return new CassandraColumnManagerFactory(properties.createCluster(), properties.getQueries(), executorService);
    }

    public CassandraColumnManagerFactory apply(Settings settings) throws NullPointerException {
        Objects.requireNonNull(settings, "settings is required");
        HashMap<String, String> configurations = new HashMap<String, String>();
        List keys = settings.keySet().stream().filter(k -> k.startsWith("jnosql.")).collect(Collectors.toUnmodifiableList());
        for (String key : keys) {
            settings.get(key, String.class).ifPresent(v -> configurations.put(key, (String)v));
        }
        return this.getManagerFactory(configurations);
    }
}

