/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.cassandra.column;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import jakarta.nosql.Value;
import jakarta.nosql.column.Column;
import jakarta.nosql.column.ColumnEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.cassandra.column.UDT;

final class CassandraConverter {
    private CassandraConverter() {
    }

    public static ColumnEntity toDocumentEntity(Row row) {
        ArrayList<Column> columns = new ArrayList<Column>();
        String columnFamily = "";
        for (ColumnDefinition definition : row.getColumnDefinitions()) {
            columnFamily = definition.getTable().asInternal();
            Object result = CassandraConverter.get(definition, row);
            if (!Objects.nonNull(result)) continue;
            columns.add(CassandraConverter.getColumn(definition, result));
        }
        return ColumnEntity.of((String)columnFamily, columns);
    }

    private static Column getColumn(ColumnDefinition definition, Object result) {
        DataType type = definition.getType();
        switch (type.getProtocolCode()) {
            case 48: {
                return (Column)Column.class.cast(result);
            }
            case 32: 
            case 34: {
                if (CassandraConverter.isUDTIterable(result)) {
                    return UDT.builder(CassandraConverter.getUserType(result)).withName(definition.getName().asInternal()).addUDTs(CassandraConverter.getColumns(definition, result)).build();
                }
                return Column.of((String)definition.getName().asInternal(), (Object)Value.of((Object)result));
            }
        }
        return Column.of((String)definition.getName().asInternal(), (Object)Value.of((Object)result));
    }

    static Object get(ColumnDefinition definition, Row row) {
        String name = definition.getName().asInternal();
        DataType type = definition.getType();
        if (type instanceof UserDefinedType) {
            return CassandraConverter.getUDT(definition, row.getUdtValue(name));
        }
        TypeCodec codec = row.codecRegistry().codecFor(type);
        return row.get(name, codec);
    }

    private static UDT getUDT(ColumnDefinition definition, UdtValue udtValue) {
        String name = definition.getName().asInternal();
        UserDefinedType type = udtValue.getType();
        ArrayList<Column> columns = new ArrayList<Column>();
        List names = type.getFieldNames().stream().map(CqlIdentifier::asInternal).collect(Collectors.toList());
        for (CqlIdentifier fieldName : type.getFieldNames()) {
            int index = names.indexOf(fieldName.asInternal());
            DataType fieldType = (DataType)type.getFieldTypes().get(index);
            Object elementValue = udtValue.get(fieldName, CodecRegistry.DEFAULT.codecFor(fieldType));
            if (elementValue == null) continue;
            columns.add(Column.of((String)fieldName.asInternal(), (Object)elementValue));
        }
        return UDT.builder(type.getName().asInternal()).withName(name).addUDT(columns).build();
    }

    private static String getUserType(Object result) {
        return StreamSupport.stream(((Iterable)Iterable.class.cast(result)).spliterator(), false).limit(1L).map(c -> ((UdtValue)UdtValue.class.cast(c)).getType().getName().asInternal()).findFirst().get().toString();
    }

    private static Iterable<Iterable<Column>> getColumns(ColumnDefinition definition, Object result) {
        ArrayList<Iterable<Column>> columns = new ArrayList<Iterable<Column>>();
        for (Object value : (Iterable)Iterable.class.cast(result)) {
            UdtValue udtValue = (UdtValue)UdtValue.class.cast(value);
            UDT udt = CassandraConverter.getUDT(definition, udtValue);
            columns.add((Iterable)udt.get());
        }
        return columns;
    }

    private static boolean isUDTIterable(Object result) {
        Iterable iterable = (Iterable)Iterable.class.cast(result);
        if (!iterable.iterator().hasNext()) {
            return false;
        }
        return StreamSupport.stream(iterable.spliterator(), false).allMatch(UdtValue.class::isInstance);
    }
}

