/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.cassandra.column;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import jakarta.nosql.column.ColumnEntity;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.cassandra.column.CassandraConverter;

public class CassandraPreparedStatement {
    private final PreparedStatement prepare;
    private final CqlSession session;
    private BoundStatement boundStatement;

    CassandraPreparedStatement(PreparedStatement prepare, CqlSession session) {
        this.prepare = prepare;
        this.session = session;
    }

    public Stream<ColumnEntity> executeQuery() {
        this.load();
        ResultSet resultSet = this.session.execute((Statement)this.boundStatement);
        return resultSet.all().stream().map(CassandraConverter::toDocumentEntity);
    }

    public CassandraPreparedStatement bind(Object ... values) {
        this.boundStatement = this.prepare.bind(values);
        return this;
    }

    private void load() {
        if (this.boundStatement == null) {
            this.boundStatement = this.prepare.bind(new Object[0]);
        }
    }

    public String toString() {
        return "CassandraPreparedStatement{prepare=" + this.prepare + ", session=" + this.session + ", boundStatement=" + this.boundStatement + "}";
    }
}

