/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.cassandra.column;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import jakarta.nosql.Settings;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.eclipse.jnosql.communication.cassandra.column.CassandraConfigurations;

class CassandraProperties {
    private static final int DEFAULT_PORT = 9042;
    private static final String DEFAULT_DATA_CENTER = "datacenter1";
    private final List<String> queries = new ArrayList<String>();
    private final List<String> nodes = new ArrayList<String>();
    private Optional<String> name;
    private Optional<String> user;
    private Optional<String> password;
    private int port;
    private String dataCenter;

    CassandraProperties() {
    }

    public void addQuery(String query) {
        this.queries.add(query);
    }

    public void addNodes(String node) {
        this.nodes.add(node);
    }

    public List<String> getQueries() {
        return this.queries;
    }

    public CqlSessionBuilder createCluster() {
        CqlSessionBuilder builder = CqlSession.builder();
        this.nodes.stream().map(h -> new InetSocketAddress((String)h, this.port)).forEach(arg_0 -> ((CqlSessionBuilder)builder).addContactPoint(arg_0));
        this.name.ifPresent(arg_0 -> ((CqlSessionBuilder)builder).withApplicationName(arg_0));
        builder.withLocalDatacenter(this.dataCenter);
        if (this.user.isPresent()) {
            builder.withAuthCredentials(this.user.orElse(""), this.password.orElse(""));
        }
        return builder;
    }

    public ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool();
    }

    public static CassandraProperties of(Map<String, String> configurations) {
        Settings.SettingsBuilder builder = Settings.builder();
        configurations.forEach((key, value) -> builder.put(key, value));
        Settings settings = builder.build();
        CassandraProperties cp = new CassandraProperties();
        settings.prefix((Supplier)CassandraConfigurations.HOST).stream().map(Object::toString).forEach(cp::addNodes);
        settings.prefix((Supplier)CassandraConfigurations.QUERY).stream().map(Object::toString).forEach(cp::addQuery);
        cp.port = settings.get((Supplier)CassandraConfigurations.PORT).map(Object::toString).map(Integer::parseInt).orElse(9042);
        cp.name = settings.get((Supplier)CassandraConfigurations.NAME).map(Object::toString);
        cp.dataCenter = settings.get((Supplier)CassandraConfigurations.DATA_CENTER).map(Object::toString).orElse(DEFAULT_DATA_CENTER);
        cp.user = settings.get((Supplier)CassandraConfigurations.USER).map(Object::toString);
        cp.password = settings.get((Supplier)CassandraConfigurations.PASSWORD).map(Object::toString);
        return cp;
    }
}

