/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.cassandra.column;

import jakarta.nosql.Sort;
import jakarta.nosql.column.ColumnCondition;
import jakarta.nosql.column.ColumnQuery;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public final class CassandraQuery
implements ColumnQuery {
    private static final String EXHAUSTED = "EXHAUSTED";
    private static final Predicate<String> EQUALS = "EXHAUSTED"::equals;
    private static final Predicate<String> NOT_EQUALS = EQUALS.negate();
    private final ColumnQuery query;
    private String pagingState;

    private CassandraQuery(ColumnQuery query) {
        this.query = query;
    }

    public Optional<String> getPagingState() {
        return Optional.ofNullable(this.pagingState);
    }

    Optional<ByteBuffer> toPaginate() {
        return this.getPagingState().filter(NOT_EQUALS).map(s -> ByteBuffer.wrap(s.getBytes(StandardCharsets.UTF_8)));
    }

    void setPagingState(ByteBuffer pagingState) {
        if (pagingState != null) {
            this.pagingState = StandardCharsets.UTF_8.decode(pagingState).toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExhausted(boolean exhausted) {
        CassandraQuery cassandraQuery = this;
        synchronized (cassandraQuery) {
            if (exhausted) {
                this.pagingState = EXHAUSTED;
            }
        }
    }

    boolean isExhausted() {
        return EXHAUSTED.equals(this.pagingState);
    }

    public long getLimit() {
        return this.query.getLimit();
    }

    public long getSkip() {
        return this.query.getSkip();
    }

    public String getColumnFamily() {
        return this.query.getColumnFamily();
    }

    public Optional<ColumnCondition> getCondition() {
        return this.query.getCondition();
    }

    public List<Sort> getSorts() {
        return this.query.getSorts();
    }

    public List<String> getColumns() {
        return this.query.getColumns();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraQuery that = (CassandraQuery)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.pagingState, that.pagingState);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.pagingState);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CouchDBDocumentQuery{");
        sb.append("query=").append(this.query);
        sb.append(", pagingState='").append(this.pagingState).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static CassandraQuery of(ColumnQuery query) {
        Objects.requireNonNull(query, "query is required ");
        return new CassandraQuery(query);
    }

    public static CassandraQuery of(ColumnQuery query, String pagingState) {
        Objects.requireNonNull(query, "query is required ");
        Objects.requireNonNull(pagingState, "pagingState is required ");
        CassandraQuery cassandraQuery = new CassandraQuery(query);
        cassandraQuery.pagingState = pagingState;
        return cassandraQuery;
    }
}

