/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.cassandra.column;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import jakarta.nosql.column.ColumnDeleteQuery;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnQuery;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.cassandra.column.CassandraColumnManager;
import org.eclipse.jnosql.communication.cassandra.column.CassandraConverter;
import org.eclipse.jnosql.communication.cassandra.column.CassandraPreparedStatement;
import org.eclipse.jnosql.communication.cassandra.column.DeleteQueryConverter;
import org.eclipse.jnosql.communication.cassandra.column.QueryExecutor;
import org.eclipse.jnosql.communication.cassandra.column.QueryUtils;

class DefaultCassandraColumnManager
implements CassandraColumnManager {
    private final CqlSession session;
    private final Executor executor;
    private final String keyspace;

    DefaultCassandraColumnManager(CqlSession session, Executor executor, String keyspace) {
        this.session = session;
        this.executor = executor;
        this.keyspace = keyspace;
    }

    public String getName() {
        return this.keyspace;
    }

    public ColumnEntity insert(ColumnEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        Insert insert = QueryUtils.insert(entity, this.keyspace, this.session, null);
        this.session.execute((Statement)insert.build());
        return entity;
    }

    public ColumnEntity insert(ColumnEntity entity, Duration duration) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(duration, "duration is required");
        Insert insert = QueryUtils.insert(entity, this.keyspace, this.session, duration);
        this.session.execute((Statement)insert.build());
        return entity;
    }

    public ColumnEntity update(ColumnEntity entity) {
        return this.insert(entity);
    }

    public Iterable<ColumnEntity> update(Iterable<ColumnEntity> entities) {
        return this.insert(entities);
    }

    public Iterable<ColumnEntity> insert(Iterable<ColumnEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::insert).collect(Collectors.toList());
    }

    public Iterable<ColumnEntity> insert(Iterable<ColumnEntity> entities, Duration duration) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(duration, "entities is duration");
        return StreamSupport.stream(entities.spliterator(), false).map(d -> this.insert((ColumnEntity)d, duration)).collect(Collectors.toList());
    }

    @Override
    public ColumnEntity save(ColumnEntity entity, ConsistencyLevel level) {
        Objects.requireNonNull(entity, "entities is required");
        Objects.requireNonNull(level, "level is required");
        Insert insert = QueryUtils.insert(entity, this.keyspace, this.session, null);
        this.session.execute(insert.build().setConsistencyLevel(level));
        return entity;
    }

    @Override
    public ColumnEntity save(ColumnEntity entity, Duration ttl, ConsistencyLevel level) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(level, "level is required");
        Objects.requireNonNull(ttl, "ttl is required");
        Insert insert = QueryUtils.insert(entity, this.keyspace, this.session, ttl);
        this.session.execute(insert.build().setConsistencyLevel(level));
        return entity;
    }

    @Override
    public Iterable<ColumnEntity> save(Iterable<ColumnEntity> entities, ConsistencyLevel level) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(level, "level is required");
        return StreamSupport.stream(entities.spliterator(), false).map(c -> this.save((ColumnEntity)c, level)).collect(Collectors.toList());
    }

    @Override
    public Iterable<ColumnEntity> save(Iterable<ColumnEntity> entities, Duration ttl, ConsistencyLevel level) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(level, "level is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return StreamSupport.stream(entities.spliterator(), false).map(c -> this.save((ColumnEntity)c, ttl, level)).collect(Collectors.toList());
    }

    public Stream<ColumnEntity> select(ColumnQuery query) {
        Objects.requireNonNull(query, "query is required");
        QueryExecutor executor = QueryExecutor.of(query);
        return executor.execute(this.keyspace, query, this);
    }

    @Override
    public Stream<ColumnEntity> select(ColumnQuery query, ConsistencyLevel level) throws NullPointerException {
        Objects.requireNonNull(query, "query is required");
        QueryExecutor executor = QueryExecutor.of(query);
        return executor.execute(this.keyspace, query, level, this);
    }

    public long count(String columnFamily) {
        Objects.requireNonNull(columnFamily, "columnFamily is required");
        ResultSet execute = this.session.execute((Statement)QueryBuilder.selectFrom((String)this.keyspace, (String)columnFamily).countAll().build());
        return ((Row)execute.one()).getLong(0);
    }

    public void close() {
        this.session.close();
    }

    @Override
    public void delete(ColumnDeleteQuery query, ConsistencyLevel level) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(level, "level is required");
        Delete delete = DeleteQueryConverter.delete(query, this.keyspace);
        SimpleStatement build = delete.build();
        SimpleStatement simpleStatement = (SimpleStatement)build.setConsistencyLevel(level);
        this.session.execute((Statement)simpleStatement);
    }

    public void delete(ColumnDeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        Delete delete = DeleteQueryConverter.delete(query, this.keyspace);
        this.session.execute((Statement)delete.build());
    }

    @Override
    public Stream<ColumnEntity> cql(String query) {
        Objects.requireNonNull(query, "query is required");
        ResultSet resultSet = this.session.execute(query);
        return resultSet.all().stream().map(CassandraConverter::toDocumentEntity);
    }

    @Override
    public Stream<ColumnEntity> cql(String query, Map<String, Object> values) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(values, "values is required");
        PreparedStatement prepare = this.session.prepare(query);
        BoundStatement statement = prepare.bind(new Object[0]);
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            TypeCodec codec = CodecRegistry.DEFAULT.codecFor(entry.getValue().getClass());
            statement = (BoundStatement)statement.set(entry.getKey(), entry.getValue(), codec);
        }
        ResultSet resultSet = this.session.execute((Statement)statement);
        return resultSet.all().stream().map(CassandraConverter::toDocumentEntity);
    }

    @Override
    public Stream<ColumnEntity> execute(SimpleStatement statement) {
        Objects.requireNonNull(statement, "statement is required");
        ResultSet resultSet = this.session.execute((Statement)statement);
        return resultSet.all().stream().map(CassandraConverter::toDocumentEntity);
    }

    @Override
    public CassandraPreparedStatement nativeQueryPrepare(String query) {
        Objects.requireNonNull(query, "query is required");
        PreparedStatement prepare = this.session.prepare(query);
        return new CassandraPreparedStatement(prepare, this.session);
    }

    CqlSession getSession() {
        return this.session;
    }

    public String toString() {
        return "DefaultCassandraColumnManager{session=" + this.session + ", keyspace='" + this.keyspace + "'}";
    }
}

