/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.cassandra.column;

import jakarta.nosql.TypeSupplier;
import jakarta.nosql.Value;
import jakarta.nosql.column.Column;
import java.util.List;
import java.util.Objects;
import org.eclipse.jnosql.communication.cassandra.column.UDT;

class DefaultUDT
implements UDT {
    private final String name;
    private final String userType;
    private final List<Column> columns;

    DefaultUDT(String name, String userType, List<Column> columns) {
        this.name = name;
        this.userType = userType;
        this.columns = columns;
    }

    public String getName() {
        return this.name;
    }

    public Value getValue() {
        return Value.of(this.columns);
    }

    public <T> T get(Class<T> clazz) throws NullPointerException, UnsupportedOperationException {
        Objects.requireNonNull(clazz, "clazz is required");
        return (T)Value.of(this.columns).get(clazz);
    }

    public <T> T get(TypeSupplier<T> typeSupplier) throws NullPointerException, UnsupportedOperationException {
        Objects.requireNonNull(typeSupplier, "typeSupplier is required");
        return (T)Value.of(this.columns).get(typeSupplier);
    }

    public Object get() {
        return this.columns;
    }

    @Override
    public String getUserType() {
        return this.userType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UDT)) {
            return false;
        }
        UDT udt = (UDT)o;
        return Objects.equals(this.name, udt.getName()) && Objects.equals(this.userType, udt.getUserType()) && Objects.equals(this.columns, udt.get());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.userType, this.columns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UDT{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", userType='").append(this.userType).append('\'');
        sb.append(", columns=").append(this.columns);
        sb.append('}');
        return sb.toString();
    }
}

