/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.cassandra.column;

import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import jakarta.nosql.column.ColumnDeleteQuery;
import org.eclipse.jnosql.communication.cassandra.column.QueryUtils;
import org.eclipse.jnosql.communication.cassandra.column.Relations;

final class DeleteQueryConverter {
    private DeleteQueryConverter() {
    }

    static Delete delete(ColumnDeleteQuery query, String keyspace) {
        String columnFamily = query.getColumnFamily();
        DeleteSelection deleteSelection = QueryBuilder.deleteFrom((String)keyspace, (String)columnFamily);
        for (String column : query.getColumns()) {
            deleteSelection = deleteSelection.column(QueryUtils.getName(column));
        }
        Delete delete = (Delete)deleteSelection.where(Relations.createClause(query.getCondition().orElse(null)));
        return delete;
    }
}

