/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.cassandra.column;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnQuery;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.cassandra.column.CassandraConverter;
import org.eclipse.jnosql.communication.cassandra.column.CassandraQuery;
import org.eclipse.jnosql.communication.cassandra.column.DefaultCassandraColumnManager;
import org.eclipse.jnosql.communication.cassandra.column.QueryExecutor;
import org.eclipse.jnosql.communication.cassandra.column.QueryUtils;

enum QueryExecutorType implements QueryExecutor
{
    PAGING_STATE{

        @Override
        public Stream<ColumnEntity> execute(String keyspace, ColumnQuery query, DefaultCassandraColumnManager manager) {
            return this.execute(keyspace, query, null, manager);
        }

        @Override
        public Stream<ColumnEntity> execute(String keyspace, ColumnQuery q, ConsistencyLevel level, DefaultCassandraColumnManager manager) {
            CassandraQuery query = (CassandraQuery)CassandraQuery.class.cast(q);
            if (query.isExhausted()) {
                return Stream.empty();
            }
            Select select = QueryUtils.select(query, keyspace);
            SimpleStatement simpleStatement = select.build();
            if (Objects.nonNull(level)) {
                simpleStatement = (SimpleStatement)simpleStatement.setConsistencyLevel(level);
            }
            if (query.toPaginate().isPresent()) {
                simpleStatement = (SimpleStatement)simpleStatement.setPagingState(query.toPaginate().get());
            }
            ResultSet resultSet = manager.getSession().execute((Statement)simpleStatement);
            ByteBuffer pagingState = resultSet.getExecutionInfo().getPagingState();
            query.setPagingState(pagingState);
            ArrayList<ColumnEntity> entities = new ArrayList<ColumnEntity>();
            for (Row row : resultSet) {
                entities.add(CassandraConverter.toDocumentEntity(row));
                if (resultSet.getAvailableWithoutFetching() != 0) continue;
                query.setExhausted(resultSet.isFullyFetched());
                break;
            }
            return entities.stream();
        }
    }
    ,
    DEFAULT{

        @Override
        public Stream<ColumnEntity> execute(String keyspace, ColumnQuery query, DefaultCassandraColumnManager manager) {
            return this.execute(keyspace, query, null, manager);
        }

        @Override
        public Stream<ColumnEntity> execute(String keyspace, ColumnQuery query, ConsistencyLevel level, DefaultCassandraColumnManager manager) {
            Select cassandraSelect = QueryUtils.select(query, keyspace);
            if (query.getLimit() > 0L && query.getSkip() == 0L) {
                cassandraSelect = cassandraSelect.limit((int)query.getLimit());
            }
            SimpleStatement select = cassandraSelect.build();
            if (Objects.nonNull(level)) {
                select = (SimpleStatement)select.setConsistencyLevel(level);
            }
            ResultSet resultSet = manager.getSession().execute((Statement)select);
            if (query.getLimit() > 0L && query.getSkip() > 0L) {
                return resultSet.all().stream().skip(query.getSkip()).limit(query.getLimit()).map(CassandraConverter::toDocumentEntity);
            }
            return resultSet.all().stream().map(CassandraConverter::toDocumentEntity);
        }
    };

}

