/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.cassandra.column;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.CodecNotFoundException;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.insert.InsertInto;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.nosql.CommunicationException;
import jakarta.nosql.Sort;
import jakarta.nosql.SortType;
import jakarta.nosql.Value;
import jakarta.nosql.column.Column;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnQuery;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jnosql.communication.cassandra.column.Relations;
import org.eclipse.jnosql.communication.cassandra.column.UDT;
import org.eclipse.jnosql.communication.driver.ValueUtil;

final class QueryUtils {
    private QueryUtils() {
    }

    static Insert insert(ColumnEntity entity, String keyspace, CqlSession session, Duration duration) {
        HashMap values = new HashMap();
        InsertInto insert = QueryBuilder.insertInto((String)keyspace, (String)entity.getName());
        entity.getColumns().stream().forEach(c -> {
            if (UDT.class.isInstance(c)) {
                QueryUtils.insertUDT((UDT)UDT.class.cast(c), keyspace, entity.getName(), session, values);
            } else {
                QueryUtils.insertSingleField(c, values);
            }
        });
        RegularInsert regularInsert = insert.values(values);
        if (duration != null) {
            return regularInsert.usingTtl((int)duration.getSeconds());
        }
        return regularInsert;
    }

    public static Select select(ColumnQuery query, String keyspace) {
        String columnFamily = query.getColumnFamily();
        List columns = query.getColumns();
        Select select = null;
        select = columns.isEmpty() ? QueryBuilder.selectFrom((String)keyspace, (String)columnFamily).all() : QueryBuilder.selectFrom((String)keyspace, (String)columnFamily).columns((Iterable)columns);
        select = (Select)select.where(Relations.createClause(query.getCondition().orElse(null)));
        Map<String, ClusteringOrder> sort = query.getSorts().stream().collect(Collectors.toMap(Sort::getName, QueryUtils.mapSort()));
        select = select.orderBy(sort);
        return select;
    }

    private static Function<Sort, ClusteringOrder> mapSort() {
        return s -> SortType.ASC.equals((Object)s.getType()) ? ClusteringOrder.ASC : ClusteringOrder.DESC;
    }

    private static void insertUDT(UDT udt, String keyspace, String columnFamily, CqlSession session, Map<String, Term> values) {
        Optional keyspaceMetadata = session.getMetadata().getKeyspace(keyspace);
        UserDefinedType userType = (UserDefinedType)keyspaceMetadata.flatMap(ks -> ks.getUserDefinedType(udt.getUserType())).orElseThrow(() -> new IllegalArgumentException("Missing UDT definition"));
        TableMetadata tableMetadata = (TableMetadata)keyspaceMetadata.flatMap(k -> k.getTable(columnFamily)).orElseThrow(() -> new IllegalArgumentException("Missing Table definition"));
        ColumnMetadata columnMetadata = (ColumnMetadata)tableMetadata.getColumn(QueryUtils.getName(udt)).orElseThrow(() -> new IllegalArgumentException("Missing the column definition"));
        DataType type = columnMetadata.getType();
        Iterable elements = (Iterable)Iterable.class.cast(udt.get());
        Object udtValue = QueryUtils.getUdtValue(userType, elements, type);
        values.put(QueryUtils.getName(udt), (Term)QueryBuilder.literal((Object)udtValue));
    }

    private static Object getUdtValue(UserDefinedType userType, Iterable elements, DataType type) {
        Collection<Object> udtValues = QueryUtils.getCollectionUdt(type);
        UdtValue udtValue = userType.newValue();
        List udtNames = userType.getFieldNames().stream().map(CqlIdentifier::asInternal).collect(Collectors.toList());
        for (Object object : elements) {
            if (Column.class.isInstance(object)) {
                Column column = (Column)Column.class.cast(object);
                Object convert = ValueUtil.convert((Value)column.getValue());
                int index = udtNames.indexOf(column.getName());
                if (index < 0) {
                    throw new CommunicationException("This field has not been found: " + column.getName() + " the fields available are " + udtNames + " in the UDT type " + userType.getName().asCql(true) + " at the keyspace " + userType.getKeyspace());
                }
                DataType fieldType = (DataType)userType.getFieldTypes().get(index);
                TypeCodec objectTypeCodec = CodecRegistry.DEFAULT.codecFor(fieldType);
                if (fieldType instanceof SetType) {
                    udtValue.set(QueryUtils.getName(column), new HashSet((Collection)convert), objectTypeCodec);
                    continue;
                }
                udtValue.set(QueryUtils.getName(column), convert, objectTypeCodec);
                continue;
            }
            if (!Iterable.class.isInstance(object)) continue;
            udtValues.add(QueryUtils.getUdtValue(userType, (Iterable)Iterable.class.cast(Iterable.class.cast(object)), type));
        }
        if (udtValues.isEmpty()) {
            return udtValue;
        }
        return udtValues;
    }

    private static Collection<Object> getCollectionUdt(DataType type) {
        if (34 == type.getProtocolCode()) {
            return new HashSet<Object>();
        }
        return new ArrayList<Object>();
    }

    private static void insertSingleField(Column column, Map<String, Term> values) {
        Object value = column.get();
        try {
            CodecRegistry.DEFAULT.codecFor(value);
            values.put(QueryUtils.getName(column), (Term)QueryBuilder.literal((Object)value));
        }
        catch (CodecNotFoundException exp) {
            values.put(QueryUtils.getName(column), (Term)QueryBuilder.literal((Object)ValueUtil.convert((Value)column.getValue())));
        }
    }

    public static String count(String columnFamily, String keyspace) {
        return String.format("select count(*) from %s.%s", keyspace, columnFamily);
    }

    static String getName(Column column) {
        return QueryUtils.getName(column.getName());
    }

    static String getName(String name) {
        if (name.charAt(0) == '_') {
            return "\"" + name + "\"";
        }
        return name;
    }

    private static Object[] getIinValue(Value value) {
        return ValueUtil.convertToList((Value)value).toArray();
    }
}

