/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.cassandra.column;

import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.nosql.Condition;
import jakarta.nosql.TypeReference;
import jakarta.nosql.TypeSupplier;
import jakarta.nosql.Value;
import jakarta.nosql.column.Column;
import jakarta.nosql.column.ColumnCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jnosql.communication.cassandra.column.QueryUtils;
import org.eclipse.jnosql.communication.driver.ValueUtil;

final class Relations {
    private Relations() {
    }

    static List<Relation> createClause(ColumnCondition columnCondition) {
        if (Objects.isNull(columnCondition)) {
            return Collections.emptyList();
        }
        ArrayList<Relation> relations = new ArrayList<Relation>();
        Relations.load(columnCondition, relations);
        return relations;
    }

    private static void load(ColumnCondition columnCondition, List<Relation> relations) {
        Column column = columnCondition.getColumn();
        Condition condition = columnCondition.getCondition();
        switch (condition) {
            case EQUALS: {
                relations.add((Relation)Relation.column((String)QueryUtils.getName(column)).isEqualTo(Relations.getTerm(column)));
                return;
            }
            case GREATER_THAN: {
                relations.add((Relation)Relation.column((String)QueryUtils.getName(column)).isGreaterThan(Relations.getTerm(column)));
                return;
            }
            case GREATER_EQUALS_THAN: {
                relations.add((Relation)Relation.column((String)QueryUtils.getName(column)).isGreaterThanOrEqualTo(Relations.getTerm(column)));
                return;
            }
            case LESSER_THAN: {
                relations.add((Relation)Relation.column((String)QueryUtils.getName(column)).isLessThan(Relations.getTerm(column)));
                return;
            }
            case LESSER_EQUALS_THAN: {
                relations.add((Relation)Relation.column((String)QueryUtils.getName(column)).isLessThanOrEqualTo(Relations.getTerm(column)));
                return;
            }
            case IN: {
                relations.add((Relation)Relation.column((String)QueryUtils.getName(column)).in(Relations.getIinValue(column.getValue())));
                return;
            }
            case LIKE: {
                relations.add((Relation)Relation.column((String)QueryUtils.getName(column)).like(Relations.getTerm(column)));
                return;
            }
            case AND: {
                ((List)column.get((TypeSupplier)new TypeReference<List<ColumnCondition>>(){})).forEach(cc -> Relations.load(cc, relations));
                return;
            }
        }
        throw new UnsupportedOperationException("The columnCondition " + condition + " is not supported in cassandra column driver");
    }

    private static Term getTerm(Column column) {
        return QueryBuilder.literal((Object)ValueUtil.convert((Value)column.getValue()));
    }

    private static Term[] getIinValue(Value value) {
        return (Term[])ValueUtil.convertToList((Value)value).stream().map(QueryBuilder::literal).toArray(Term[]::new);
    }
}

