/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.cassandra.column;

import jakarta.nosql.column.Column;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.cassandra.column.DefaultUDT;
import org.eclipse.jnosql.communication.cassandra.column.IterableUDT;
import org.eclipse.jnosql.communication.cassandra.column.UDT;
import org.eclipse.jnosql.communication.cassandra.column.UDTElementBuilder;
import org.eclipse.jnosql.communication.cassandra.column.UDTFinisherBuilder;
import org.eclipse.jnosql.communication.cassandra.column.UDTNameBuilder;

class UDTBuilder
implements UDTNameBuilder,
UDTElementBuilder,
UDTFinisherBuilder {
    private String name;
    private final String typeName;
    private final List<Column> columns = new ArrayList<Column>();
    private Iterable<Iterable<Column>> udts = new ArrayList<Iterable<Column>>();

    UDTBuilder(String userType) {
        this.typeName = userType;
    }

    @Override
    public UDTBuilder withName(String name) throws NullPointerException {
        this.name = Objects.requireNonNull(name, "name is required");
        return this;
    }

    @Override
    public UDTBuilder addUDT(Iterable<Column> udt) throws NullPointerException {
        Objects.requireNonNull(udt, "udt is required");
        StreamSupport.stream(udt.spliterator(), false).forEach(this.columns::add);
        return this;
    }

    @Override
    public UDTBuilder addUDTs(Iterable<Iterable<Column>> udts) throws NullPointerException {
        Objects.requireNonNull(udts, "udts is required");
        this.udts = udts;
        return this;
    }

    @Override
    public UDT build() throws IllegalStateException {
        if (Objects.isNull(this.name)) {
            throw new IllegalStateException("name is required");
        }
        if (Objects.isNull(this.typeName)) {
            throw new IllegalStateException("typeName is required");
        }
        if (this.udts.spliterator().getExactSizeIfKnown() == 0L) {
            return new DefaultUDT(this.name, this.typeName, this.columns);
        }
        return new IterableUDT(this.name, this.typeName, this.udts);
    }
}

