/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column;

import jakarta.nosql.TypeSupplier;
import jakarta.nosql.Value;
import jakarta.nosql.column.Column;
import jakarta.nosql.column.ColumnEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

final class DefaultColumnEntity
implements ColumnEntity {
    private final Map<String, Column> columns = new HashMap<String, Column>();
    private final String name;

    DefaultColumnEntity(String name) {
        this.name = name;
    }

    static DefaultColumnEntity of(String name, Column ... columns) {
        if (columns.length == 0) {
            return new DefaultColumnEntity(name);
        }
        return DefaultColumnEntity.of(name, Arrays.asList(columns));
    }

    static DefaultColumnEntity of(String name, List<Column> columns) {
        DefaultColumnEntity columnEntity = new DefaultColumnEntity(name);
        columnEntity.addAll(columns);
        return columnEntity;
    }

    public void addAll(List<Column> columns) {
        Objects.requireNonNull(columns, "The object column is required");
        columns.forEach(this::add);
    }

    public void add(Column column) {
        Objects.requireNonNull(column, "Column is required");
        this.columns.put(column.getName(), column);
    }

    public void add(String columnName, Object value) {
        Objects.requireNonNull(columnName, "columnName is required");
        Objects.requireNonNull(value, "value is required");
        this.columns.put(columnName, Column.of((String)columnName, (Object)Value.of((Object)value)));
    }

    public void add(String columnName, Value value) {
        Objects.requireNonNull(columnName, "columnName is required");
        Objects.requireNonNull(value, "value is required");
        this.columns.put(columnName, Column.of((String)columnName, (Object)value));
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Column> entry : this.columns.entrySet()) {
            Column column = entry.getValue();
            map.put(entry.getKey(), this.convert(column.get()));
        }
        return Collections.unmodifiableMap(map);
    }

    private Object convert(Object value) {
        if (value instanceof Column) {
            Column column = (Column)Column.class.cast(value);
            return Collections.singletonMap(column.getName(), this.convert(column.get()));
        }
        if (value instanceof Iterable) {
            ArrayList list = new ArrayList();
            ((Iterable)Iterable.class.cast(value)).forEach(e -> list.add(this.convert(e)));
            return list;
        }
        return value;
    }

    public List<Column> getColumns() {
        return this.columns.values().stream().collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public String getName() {
        return this.name;
    }

    public boolean remove(String columnName) {
        Objects.requireNonNull(columnName, "columnName is required");
        return this.columns.remove(columnName) != null;
    }

    public Optional<Column> find(String columnName) {
        Objects.requireNonNull(columnName, "columnName is required");
        Column column = this.columns.get(columnName);
        return Optional.ofNullable(column);
    }

    public <T> Optional<T> find(String columnName, Class<T> type) {
        Objects.requireNonNull(columnName, "columnName is required");
        Objects.requireNonNull(type, "type is required");
        return Optional.ofNullable(this.columns.get(columnName)).map(c -> c.get(type));
    }

    public <T> Optional<T> find(String columnName, TypeSupplier<T> type) {
        Objects.requireNonNull(columnName, "columnName is required");
        Objects.requireNonNull(type, "type is required");
        return Optional.ofNullable(this.columns.get(columnName)).map(v -> v.get(type));
    }

    public int size() {
        return this.columns.size();
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public ColumnEntity copy() {
        DefaultColumnEntity entity = new DefaultColumnEntity(this.name);
        entity.columns.putAll(new HashMap<String, Column>(this.columns));
        return entity;
    }

    public Set<String> getColumnNames() {
        return Collections.unmodifiableSet(this.columns.keySet());
    }

    public Collection<Value> getValues() {
        return this.columns.values().stream().map(Column::getValue).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public boolean contains(String columnName) {
        Objects.requireNonNull(columnName, "columnName is required");
        return this.columns.containsKey(columnName);
    }

    public void clear() {
        this.columns.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultColumnEntity that = (DefaultColumnEntity)o;
        return Objects.equals(this.columns, that.columns) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.name);
    }

    public String toString() {
        return "DefaultColumnEntity{columns=" + this.toMap() + ", name='" + this.name + "'}";
    }
}

